/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.PrintWriter;
import java.io.Serializable;
import net.thetadata.enums.AccountType;
import net.thetadata.enums.SecType;

public class User2
implements Serializable {
    private static final long serialVersionUID = 1L;
    private volatile String email;
    private volatile String ip;
    private volatile String salt;
    private volatile String hash;
    private volatile String tokenHash;
    private volatile AccountType stkPlan;
    private volatile AccountType optPlan;
    private volatile AccountType idxPlan;
    private volatile AccountType ratePlan;
    private volatile long lastOnline;
    private volatile AccountType maxAcc = AccountType.FREE;
    private volatile transient long lastMsg;
    private static final AccountType[] values = new AccountType[4];

    public User2(String user, AccountType stkAcc, AccountType optAcc, AccountType indAcc, AccountType rateAcc) {
        this.email = user;
        this.stkPlan = stkAcc;
        this.optPlan = optAcc;
        this.idxPlan = indAcc;
        this.ratePlan = rateAcc;
        this.lastOnline = System.currentTimeMillis();
    }

    public AccountType maxAccountType() {
        for (AccountType acc : values) {
            if (this.stkPlan != acc && this.optPlan != acc && this.idxPlan != acc && this.ratePlan != acc) continue;
            this.maxAcc = acc;
        }
        return this.maxAcc;
    }

    public User2() {
    }

    public String getTokenHash() {
        return this.tokenHash;
    }

    public void setTokenHash(String tokenHash) {
        this.tokenHash = tokenHash;
        this.lastOnline = System.currentTimeMillis();
    }

    public void setEmail(String s2) {
        this.email = s2;
        this.lastOnline = System.currentTimeMillis();
    }

    public String email() {
        return this.email;
    }

    public void deserialize(String fileData) throws NumberFormatException {
        JsonObject obj = JsonParser.parseString(fileData).getAsJsonObject();
        this.email = obj.get("email").getAsString();
        this.salt = obj.get("salt").getAsString();
        this.hash = obj.get("hash").getAsString();
        this.tokenHash = obj.get("token_hash") != null ? obj.get("tokenHash").getAsString() : null;
        this.lastOnline = System.currentTimeMillis();
        this.stkPlan = AccountType.valueOf(obj.get("stock_plan").getAsString());
        this.optPlan = AccountType.valueOf(obj.get("option_plan").getAsString());
        this.idxPlan = AccountType.valueOf(obj.get("index_plan").getAsString());
        this.ratePlan = AccountType.valueOf(obj.get("rate_plan").getAsString());
    }

    public void serialize(PrintWriter w) {
        JsonObject out = new JsonObject();
        out.addProperty("email", this.email);
        out.addProperty("ip", this.ip);
        out.addProperty("salt", this.salt);
        out.addProperty("hash", this.hash);
        out.addProperty("tokenHash", this.tokenHash);
        out.addProperty("lastOnline", System.currentTimeMillis());
        out.addProperty("stock_plan", this.stkPlan.name());
        out.addProperty("option_plan", this.optPlan.name());
        out.addProperty("index_plan", this.idxPlan.name());
        out.addProperty("rate_plan", this.ratePlan.name());
        w.println(new GsonBuilder().setPrettyPrinting().create().toJson(out));
    }

    public long getLastMsg() {
        return this.lastMsg;
    }

    public void setLastMsg(long lastMsg) {
        this.lastMsg = lastMsg;
    }

    public void copyFromSiteUser(User2 other) {
        this.email = other.email;
        this.stkPlan = other.stkPlan;
        this.optPlan = other.optPlan;
        this.idxPlan = other.idxPlan;
        this.ratePlan = other.ratePlan;
    }

    public AccountType accountType(SecType sec) {
        switch (sec) {
            case STOCK: {
                return this.stkPlan;
            }
            case OPTION: {
                return this.optPlan;
            }
            case INDEX: {
                return this.idxPlan;
            }
            case RATE: {
                return this.ratePlan;
            }
        }
        return AccountType.FREE;
    }

    public boolean equals(Object o) {
        if (!(o instanceof User2)) {
            return false;
        }
        return ((User2)o).email.equalsIgnoreCase(this.email);
    }

    public int hashCode() {
        return this.email.toLowerCase().hashCode();
    }

    public String toString() {
        return this.email;
    }

    public long getLastOnline() {
        return this.lastOnline;
    }

    public void setLastOnline(long lastOnline) {
        this.lastOnline = lastOnline;
    }

    public void setHash(String hash) {
        this.hash = hash;
        this.lastOnline = System.currentTimeMillis();
    }

    public String getHash() {
        return this.hash;
    }

    public void setSalt(String salt) {
        this.salt = salt;
        this.lastOnline = System.currentTimeMillis();
    }

    public String getSalt() {
        return this.salt;
    }

    public String getEmail() {
        return this.email;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
        this.lastOnline = System.currentTimeMillis();
    }

    public AccountType getStkPlan() {
        return this.stkPlan;
    }

    public AccountType getOptPlan() {
        return this.optPlan;
    }

    public AccountType getIdxPlan() {
        return this.idxPlan;
    }

    public AccountType getRatePlan() {
        return this.ratePlan;
    }

    static {
        User2.values[0] = AccountType.FREE;
        User2.values[1] = AccountType.VALUE;
        User2.values[2] = AccountType.STANDARD;
        User2.values[3] = AccountType.PRO;
    }
}

