/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import net.thetadata.User2;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserDB {
    private static final Logger logger = LogManager.getLogger(UserDB.class);
    private static File users;
    private static ConcurrentHashMap<String, User2> emailMap;

    public static void init(File root, String fileName, int autoSaveDuration) {
        users = new File(root, fileName);
        Preconditions.checkState(users.exists() || users.mkdirs(), "Failed to make users directory");
        File[] users = UserDB.users.listFiles();
        Preconditions.checkNotNull(users);
        emailMap = new ConcurrentHashMap(Math.max(32, users.length));
        for (File f : users) {
            try {
                User2 u = new User2();
                byte[] userData = Files.readAllBytes(f.toPath());
                if (userData.length == 0) continue;
                u.deserialize(new String(userData, StandardCharsets.UTF_8));
                emailMap.put(u.email(), u);
            }
            catch (Exception e) {
                logger.error("Error loading user: {}", (Object)f, (Object)e);
            }
        }
        UserDB.autoSave(autoSaveDuration);
    }

    private static void autoSave(int autoSaveDuration) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                UserDB.save();
            }
        }, 4000L, (long)autoSaveDuration);
    }

    public static synchronized void save() {
        for (String s2 : emailMap.keySet()) {
            try {
                PrintWriter w = new PrintWriter(new FileWriter(new File(users, s2 + ".txt"), StandardCharsets.UTF_8));
                emailMap.get(s2).serialize(w);
                w.close();
            }
            catch (Exception e) {
                logger.error("Error saving", (Throwable)e);
            }
        }
    }

    public static void insert(User2 u) {
        emailMap.put(u.email(), u);
    }

    public static User2 byEmail(String email) {
        return emailMap.get(email);
    }
}

