/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.api.types;

public enum MessageType {
    CREDENTIALS(0),
    SESSION_TOKEN(1),
    INFO(2),
    METADATA(3),
    CONNECTED(4),
    VERSION(5),
    PING(100),
    ERROR(101),
    DISCONNECTED(102),
    RECONNECTED(103),
    REQ_SYMS(104),
    SET_SYMS(105),
    CANT_CHANGE_SYMS(106),
    CHANGED_SYMS(107),
    KILL(108),
    HIST(200),
    ALL_EXPIRATIONS(201),
    ALL_STRIKES(202),
    HIST_END(203),
    LAST(204),
    ALL_ROOTS(205),
    LIST_END(206),
    ALL_DATES(207),
    AT_TIME(208),
    ALL_DATES_BULK(209),
    STREAM_REQ(210),
    STREAM_CALLBACK(211),
    STREAM_REMOVE(212),
    LAST_BULK(213),
    HIST_BULK(214),
    CONTRACT_BULK(215),
    AT_TIME_BULK(216),
    FLAT_FILE(217),
    FLAT_FILE_END(218),
    REQUEST_SERVER_LIST(300),
    REQUEST_OPTIMAL_SERVER(301),
    OPTIMAL_SERVER(302),
    PACKET(303),
    BAN_IP(304),
    POPULATION(305);

    private final short code;

    private MessageType(int code) {
        this.code = (short)code;
    }

    public short code() {
        return this.code;
    }

    public static MessageType from(short code) {
        for (MessageType m4 : MessageType.values()) {
            if (m4.code() != code) continue;
            return m4;
        }
        return null;
    }
}

