/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.cfg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Properties;
import net.thetadata.terminal.App;

public class Config {
    private static Properties values;
    private static final HashMap<String, String> reflections;

    public static void load(File configFile, int clientPortAdd) throws IOException {
        values = new Properties();
        if (!configFile.exists()) {
            try {
                Config.createDefaultConfig(configFile);
                App.logger.warn("Configuration file not found: created a default config file.");
            }
            catch (IOException e) {
                App.logger.error("Failed to create default config file: {}", (Object)e.getMessage());
                return;
            }
        }
        values.load(new FileInputStream(configFile));
        if (clientPortAdd != 0) {
            int clientPort = Integer.parseInt(values.getProperty("CLIENT_PORT"));
            values.setProperty("CLIENT_PORT", Integer.toString(clientPort + clientPortAdd));
            App.logger.info("Adding {} to CLIENT_PORT ({}) => {}", (Object)clientPortAdd, (Object)clientPort, (Object)(clientPort + clientPortAdd));
        }
        Config.verify(configFile);
        boolean reflected = false;
        for (String s2 : values.stringPropertyNames()) {
            if (!reflections.containsKey(s2)) continue;
            reflected = true;
            values.setProperty(reflections.get(s2), values.getProperty(s2));
        }
        if (reflected) {
            App.logger.warn("Certain configuration values were reflected. This is safe to ignore. You can get rid of this message by deleting your config file and restarting the Theta Terminal.");
        }
    }

    public static void verify(File configFile) throws IOException {
        String t2;
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        BufferedReader r = new BufferedReader(new InputStreamReader(App.class.getClassLoader().getResource("default_config.properties").openStream()));
        while ((t2 = r.readLine()) != null) {
            if (t2.isEmpty() || t2.charAt(0) == '#') continue;
            t2 = t2.replace(" ", "");
            defaultValues.put(t2.substring(0, t2.indexOf(61)), t2.substring(t2.indexOf(61) + 1));
        }
        PrintWriter w = null;
        for (String s2 : defaultValues.keySet()) {
            if (values.containsKey(s2)) continue;
            if (w == null) {
                w = new PrintWriter(new FileWriter(configFile, true));
            }
            values.put(s2, defaultValues.get(s2));
            w.println(s2 + " = " + (String)defaultValues.get(s2));
            App.logger.info("Added new config value: " + s2 + " key: " + (String)defaultValues.get(s2));
        }
        if (w != null) {
            w.close();
        }
        r.close();
    }

    private static void createDefaultConfig(File configFile) throws IOException {
        try {
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        try (FileOutputStream out = new FileOutputStream(configFile);){
            out.write(App.class.getClassLoader().getResourceAsStream("default_config.properties").readAllBytes());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static synchronized String getStr(String key) {
        return values.getProperty(key);
    }

    public static synchronized int getInt(String key) {
        String out = values.getProperty(key);
        return out == null ? -1 : Integer.parseInt(values.getProperty(key));
    }

    public static String workingDir() {
        return System.getProperty("user.home") + File.separator + "ThetaData" + File.separator + "ThetaTerminal";
    }

    static {
        reflections = new HashMap();
        reflections.put("TEST_HOSTS", "MDDS_STAGE_HOSTS");
        reflections.put("NJ_HOSTS", "MDDS_NJ_HOSTS");
        reflections.put("HOSTS", "MDDS_HOSTS");
        reflections.put("REGION", "MDDS_REGION");
        reflections.put("STREAM_REGION", "FPSS_REGION");
        reflections.put("HTTP_0_PORT", "HTTP_PORT");
        reflections.put("NJ_STREAM_HOSTS", "FPSS_NJ_HOSTS");
        reflections.put("TEST_STREAM_HOSTS", "FPSS_STAGE_HOSTS");
    }
}

