/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import net.thetadata.Tick;
import net.thetadata.enums.DataType;
import net.thetadata.enums.ReqArg;
import net.thetadata.enums.ReqType;
import net.thetadata.enums.SecType;
import net.thetadata.terminal.App;
import net.thetadata.terminal.Contract;
import net.thetadata.terminal.api.types.MessageType;
import net.thetadata.terminal.cfg.Config;
import net.thetadata.terminal.client.RestQueryMessage;
import net.thetadata.terminal.flatfiles.FileBuilder;
import net.thetadata.terminal.net.FITReader;
import net.thetadata.terminal.net.MDDSClient;
import net.thetadata.terminal.types.DataRequest;
import net.thetadata.terminal.types.ErrorMsg;
import net.thetadata.terminal.types.utils.Utils;

public class RESTServer {
    private final HttpServer server;
    private final ConcurrentHashMap<Long, HttpExchange> inflightExchanges = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, DataRequest> inflightRequests = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Long> inflightLatencies = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, PageInfo> pageMeta = new ConcurrentHashMap();
    private static final String CSV_TYPE = "text/csv";
    private static final String JSON_TYPE = "application/json";
    private final ArrayBlockingQueue<HttpBuffer> httpBuffers;
    private final AtomicLong pageIDGenerator = new AtomicLong();
    private static final String controlOrigin = "*";
    private volatile String lastIP;
    private final String paginationPrefix = "http://127.0.0.1:" + Config.getInt("HTTP_PORT");
    private final long pageExpire = Config.getInt("HTTP_PAGE_EXPIRE");
    private final int concurrency;

    public RESTServer(String host, int port, int concurrency) throws IOException {
        this.concurrency = concurrency;
        this.httpBuffers = new ArrayBlockingQueue(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            this.httpBuffers.add(new HttpBuffer());
        }
        this.server = HttpServer.create(new InetSocketAddress(host, port), 0x100000);
        this.registerMisc();
        this.registerHists();
        this.registerSnapshots();
        this.registerBulkSnapshots();
        this.registerBulkHist();
        this.registerBulkContract();
        this.registerPagerV2();
        this.registerMiscV2();
        this.registerHistsV2();
        this.registerSnapshotsV2();
        this.registerBulkSnapshotsV2();
        this.registerBulkHistV2();
        this.registerBulkContractV2();
        this.registerSystemCmdsV2();
        this.registerFilesV2();
        this.registerDebug();
        this.server.setExecutor(Executors.newFixedThreadPool(concurrency));
        this.server.start();
    }

    private boolean checkPath(String prefix, HttpExchange exchange) throws IOException {
        String path = exchange.getRequestURI().getPath();
        if (!path.startsWith(prefix)) {
            exchange.sendResponseHeaders(404, 0L);
            exchange.close();
            return true;
        }
        return false;
    }

    public void shutdown() {
        this.server.stop(0);
    }

    private void registerHists() {
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                String prefix = "/hist/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    try {
                        if (this.checkPath(prefix, exchange)) {
                            return;
                        }
                        if (!this.singleIPCheck(exchange)) {
                            return;
                        }
                        App.logger.warn("You are using a deprecated URL, please use the v2 version: /v2{}", (Object)prefix);
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "");
                        DataRequest req = new DataRequest(MessageType.HIST, 0L, args);
                        long id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightRequests.put(id, req);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().write(req, true)) {
                            this.sendError(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.error("ERROR", (Throwable)e);
                        try {
                            this.sendError(ErrorMsg.INVALID_PARAMS, -1L, "Error parsing data request.");
                        }
                        catch (Exception x) {
                            App.logger.debug("Error sending error message", (Throwable)x);
                        }
                    }
                });
            }
        }
    }

    private void registerMisc() {
        String prefix;
        this.server.createContext("/list/roots", exchange -> {
            try {
                if (this.checkPath("/list/roots", exchange)) {
                    return;
                }
                if (!this.singleIPCheck(exchange)) {
                    return;
                }
                App.logger.warn("You are using a deprecated URL, please use the v2 version: /v2/list/roots");
                String args = exchange.getRequestURI().getQuery();
                DataRequest req = new DataRequest(MessageType.ALL_ROOTS, 0L, args);
                long id = req.getId();
                this.inflightExchanges.put(id, exchange);
                this.inflightLatencies.put(id, System.currentTimeMillis());
                if (App.getMdds() != null && App.getMdds().isConnected()) {
                    App.getMdds().write(req, true);
                }
            }
            catch (Exception e) {
                App.logger.error("ERROR", (Throwable)e);
                try {
                    this.sendError(ErrorMsg.INVALID_PARAMS, -1L, "Error parsing data request.");
                }
                catch (Exception x) {
                    App.logger.debug("Error sending error message", (Throwable)x);
                }
            }
        });
        this.server.createContext("/list/expirations", exchange -> {
            try {
                if (this.checkPath("/list/expirations", exchange)) {
                    return;
                }
                App.logger.warn("You are using a deprecated URL, please use the v2 version: /v2/list/expirations");
                String args = exchange.getRequestURI().getQuery();
                DataRequest req = new DataRequest(MessageType.ALL_EXPIRATIONS, 0L, args);
                long id = req.getId();
                this.inflightExchanges.put(id, exchange);
                this.inflightLatencies.put(id, System.currentTimeMillis());
                if (App.getMdds() != null && App.getMdds().isConnected()) {
                    App.getMdds().write(req, true);
                }
            }
            catch (Exception e) {
                App.logger.error("ERROR", (Throwable)e);
                try {
                    this.sendError(ErrorMsg.INVALID_PARAMS, -1L, "Error parsing data request.");
                }
                catch (Exception x) {
                    App.logger.debug("Error sending error message", (Throwable)x);
                }
            }
        });
        this.server.createContext("/list/strikes", exchange -> {
            try {
                if (this.checkPath("/list/strikes", exchange)) {
                    return;
                }
                App.logger.warn("You are using a deprecated URL, please use the v2 version: /v2/list/strikes");
                String args = exchange.getRequestURI().getQuery();
                DataRequest req = new DataRequest(MessageType.ALL_STRIKES, 0L, args);
                long id = req.getId();
                this.inflightExchanges.put(id, exchange);
                this.inflightLatencies.put(id, System.currentTimeMillis());
                if (App.getMdds() != null && App.getMdds().isConnected()) {
                    App.getMdds().write(req, true);
                }
            }
            catch (Exception e) {
                App.logger.error("ERROR", (Throwable)e);
                try {
                    this.sendError(ErrorMsg.INVALID_PARAMS, -1L, "Error parsing data request.");
                }
                catch (Exception x) {
                    App.logger.debug("Error sending error message", (Throwable)x);
                }
            }
        });
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                prefix = "/list/dates/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    if (this.checkPath(prefix, exchange)) {
                        return;
                    }
                    App.logger.warn("You are using a deprecated URL, please use the v2 version: /v2{}", (Object)prefix);
                    String queryArgs = exchange.getRequestURI().getQuery();
                    String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "");
                    DataRequest req = new DataRequest(args.contains("strike") && sec == SecType.OPTION ? MessageType.ALL_DATES : MessageType.ALL_DATES_BULK, 0L, args);
                    long id = req.getId();
                    this.inflightExchanges.put(id, exchange);
                    this.inflightLatencies.put(id, System.currentTimeMillis());
                    try {
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().write(req, true)) {
                            this.sendError(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.error("ERROR", (Throwable)e);
                        try {
                            this.sendError(ErrorMsg.INVALID_PARAMS, -1L, "Error parsing data request.");
                        }
                        catch (Exception x) {
                            App.logger.debug("Error sending error message", (Throwable)x);
                        }
                    }
                });
            }
        }
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                prefix = "/at_time/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    try {
                        if (this.checkPath(prefix, exchange)) {
                            return;
                        }
                        App.logger.warn("You are using a deprecated URL, please use the v2 version: /v2{}", (Object)prefix);
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "");
                        DataRequest req = new DataRequest(MessageType.AT_TIME, 0L, args);
                        long id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().write(req, true)) {
                            this.sendError(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.error("ERROR", (Throwable)e);
                        try {
                            this.sendError(ErrorMsg.INVALID_PARAMS, -1L, "Error parsing data request.");
                        }
                        catch (Exception x) {
                            App.logger.debug("Error sending error message", (Throwable)x);
                        }
                    }
                });
            }
        }
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                prefix = "/bulk_at_time/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    try {
                        if (this.checkPath(prefix, exchange)) {
                            return;
                        }
                        App.logger.warn("You are using a deprecated URL, please use the v2 version: /v2{}", (Object)prefix);
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "");
                        DataRequest req = new DataRequest(MessageType.AT_TIME_BULK, 0L, args);
                        long id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().write(req, true)) {
                            this.sendError(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.error("ERROR", (Throwable)e);
                        try {
                            this.sendError(ErrorMsg.INVALID_PARAMS, -1L, "Error parsing data request.");
                        }
                        catch (Exception x) {
                            App.logger.debug("Error sending error message", (Throwable)x);
                        }
                    }
                });
            }
        }
    }

    public void handleConnectionLost() {
        Iterator iterator = ((ConcurrentHashMap.KeySetView)this.inflightExchanges.keySet()).iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            try {
                DataRequest req = this.inflightRequests.get(id);
                if (req == null || !req.hasArg(ReqArg.VERSION) || req.getInt(ReqArg.VERSION) == 1) {
                    this.sendError(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                    continue;
                }
                this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
            }
            catch (Exception exception) {}
        }
        this.inflightExchanges.clear();
        this.inflightRequests.clear();
        this.inflightLatencies.clear();
    }

    private void registerSnapshots() {
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                String prefix = "/snapshot/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    try {
                        if (this.checkPath(prefix, exchange)) {
                            return;
                        }
                        if (!this.singleIPCheck(exchange)) {
                            return;
                        }
                        App.logger.warn("You are using a deprecated URL, please use the v2 version: /v2{}", (Object)prefix);
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "");
                        DataRequest req = new DataRequest(MessageType.LAST, 0L, args);
                        long id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().write(req, true)) {
                            this.sendError(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.error("ERROR", (Throwable)e);
                        try {
                            this.sendError(ErrorMsg.INVALID_PARAMS, -1L, "Error parsing data request.");
                        }
                        catch (Exception x) {
                            App.logger.debug("Error sending error message", (Throwable)x);
                        }
                    }
                });
            }
        }
    }

    private void registerBulkSnapshots() {
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                String prefix = "/bulk_snapshot/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    try {
                        if (this.checkPath(prefix, exchange)) {
                            return;
                        }
                        if (!this.singleIPCheck(exchange)) {
                            return;
                        }
                        App.logger.warn("You are using a deprecated URL, please use the v2 version: /v2{}", (Object)prefix);
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "");
                        DataRequest req = new DataRequest(MessageType.LAST_BULK, 0L, args);
                        long id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightRequests.put(id, req);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().write(req, true)) {
                            this.sendError(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.error("ERROR", (Throwable)e);
                        try {
                            this.sendError(ErrorMsg.INVALID_PARAMS, -1L, "Error parsing data request.");
                        }
                        catch (Exception x) {
                            App.logger.debug("Error sending error message", (Throwable)x);
                        }
                    }
                });
            }
        }
    }

    private void registerBulkHist() {
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                String prefix = "/bulk_hist/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    try {
                        if (this.checkPath(prefix, exchange)) {
                            return;
                        }
                        if (!this.singleIPCheck(exchange)) {
                            return;
                        }
                        App.logger.warn("You are using a deprecated URL, please use the v2 version: /v2{}", (Object)prefix);
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "");
                        DataRequest req = new DataRequest(MessageType.HIST_BULK, 0L, args);
                        long id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightRequests.put(id, req);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().write(req, true)) {
                            this.sendError(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.error("ERROR", (Throwable)e);
                        try {
                            this.sendError(ErrorMsg.INVALID_PARAMS, -1L, "Error parsing data request.");
                        }
                        catch (Exception x) {
                            App.logger.debug("Error sending error message", (Throwable)x);
                        }
                    }
                });
            }
        }
    }

    private void registerBulkContract() {
        for (ReqType r : ReqType.values()) {
            String prefix = "/list/contracts/option/" + r.name().toLowerCase();
            this.server.createContext(prefix, exchange -> {
                try {
                    if (this.checkPath(prefix, exchange)) {
                        return;
                    }
                    if (!this.singleIPCheck(exchange)) {
                        return;
                    }
                    App.logger.warn("You are using a deprecated URL, please use the v2 version: /v2{}", (Object)prefix);
                    String queryArgs = exchange.getRequestURI().getQuery();
                    String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)SecType.OPTION);
                    DataRequest req = new DataRequest(MessageType.CONTRACT_BULK, 0L, args);
                    long id = req.getId();
                    this.inflightExchanges.put(id, exchange);
                    this.inflightLatencies.put(id, System.currentTimeMillis());
                    if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().write(req, true)) {
                        this.sendError(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                    }
                }
                catch (Exception e) {
                    App.logger.error("ERROR", (Throwable)e);
                    try {
                        this.sendError(ErrorMsg.INVALID_PARAMS, -1L, "Error parsing data request.");
                    }
                    catch (Exception x) {
                        App.logger.debug("Error sending error message", (Throwable)x);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsg(MessageType msg, long id, String[] list) throws InterruptedException {
        if (!this.inflightLatencies.containsKey(id)) {
            App.logger.debug("exiting request because no ID latency map could be found. Request: " + String.valueOf(this.inflightRequests.get(id)));
            return;
        }
        long latency = System.currentTimeMillis() - this.inflightLatencies.remove(id);
        HttpExchange exchange = this.inflightExchanges.get(id);
        HttpBuffer httpBuffer = this.httpBuffers.take();
        RestQueryMessage callback = httpBuffer.callback;
        httpBuffer.callback.setNextPage("null");
        try {
            callback.readHeader(id, latency, msg, null);
            callback.start();
            if (msg == MessageType.ALL_ROOTS) {
                for (String s2 : list) {
                    callback.addStr(s2);
                }
            } else {
                for (String s3 : list) {
                    callback.addInt(s3);
                }
            }
            callback.end();
            exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
            exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
            exchange.sendResponseHeaders(200, callback.length());
            if (callback.length() > httpBuffer.buff.length) {
                httpBuffer.buff = new char[callback.length()];
                httpBuffer.sendBuff = new byte[callback.length()];
            }
            callback.write(httpBuffer.buff);
            OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());
            out.write(httpBuffer.buff, 0, callback.length());
            out.flush();
            out.close();
            this.inflightExchanges.remove(id);
            exchange.close();
        }
        catch (Exception e) {
            if (exchange != null) {
                exchange.close();
            }
            if (e.getMessage() != null && (e.getMessage().contains("aborted") || e.getMessage().contains("forcibly") || e.getMessage().contains("pipe") || e.getMessage().contains("reset") || e.getMessage().contains("headers"))) {
                App.logger.debug("Skipping exception", (Throwable)e);
                return;
            }
            App.logger.error("ERROR", (Throwable)e);
        }
        finally {
            this.httpBuffers.add(httpBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void sendError(ErrorMsg msg, long id, String info) throws InterruptedException {
        App.logger.debug("sending error v1: " + String.valueOf((Object)msg) + " id: " + id + " info: " + info);
        Long reqTime = this.inflightLatencies.remove(id);
        if (reqTime == null) {
            return;
        }
        long latency = System.currentTimeMillis() - reqTime;
        HttpExchange exchange = this.inflightExchanges.get(id);
        if (exchange == null) {
            App.logger.debug("Null exchange for request ID: " + id + ". Active request IDs: " + String.valueOf(this.inflightExchanges.keySet()));
            return;
        }
        HttpBuffer httpBuffer = this.httpBuffers.take();
        RestQueryMessage callback = httpBuffer.callback;
        httpBuffer.callback.setNextPage("null");
        try {
            DataRequest req = this.inflightRequests.get(id);
            if (req != null && req.hasArg(ReqArg.USE_CSV) && req.getBoolean(ReqArg.USE_CSV)) {
                callback.toCSVError(msg, info);
                exchange.getResponseHeaders().set("Content-Type", "application/csv");
            } else {
                callback.readErrorHeader(id, latency, msg, info);
                callback.start();
                callback.addError();
                exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
            }
            exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
            exchange.sendResponseHeaders(200, callback.length());
            if (callback.length() > httpBuffer.buff.length) {
                httpBuffer.buff = new char[callback.length()];
                httpBuffer.sendBuff = new byte[callback.length()];
            }
            callback.write(httpBuffer.buff);
            OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());
            out.write(httpBuffer.buff, 0, callback.length());
            out.flush();
            out.close();
            this.inflightExchanges.remove(id);
            exchange.close();
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().contains("aborted") || e.getMessage().contains("forcibly") || e.getMessage().contains("pipe") || e.getMessage().contains("reset") || e.getMessage().contains("headers"))) {
                App.logger.debug("Skipping exception", (Throwable)e);
                return;
            }
            App.logger.error("ERROR", (Throwable)e);
            exchange.close();
        }
        finally {
            this.httpBuffers.add(httpBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void sendError(ErrorMsg msg, long id, String info, HttpExchange exchange) throws InterruptedException {
        long latency = 0L;
        HttpBuffer httpBuffer = this.httpBuffers.take();
        RestQueryMessage callback = httpBuffer.callback;
        httpBuffer.callback.setNextPage("null");
        try {
            DataRequest req = this.inflightRequests.get(id);
            if (req != null && req.hasArg(ReqArg.USE_CSV) && req.getBoolean(ReqArg.USE_CSV)) {
                callback.toCSVError(msg, info);
                exchange.getResponseHeaders().set("Content-Type", "application/csv");
            } else {
                callback.readErrorHeader(id, 0L, msg, info);
                callback.start();
                callback.addError();
                exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
            }
            exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
            exchange.sendResponseHeaders(200, callback.length());
            if (callback.length() > httpBuffer.buff.length) {
                httpBuffer.buff = new char[callback.length()];
                httpBuffer.sendBuff = new byte[callback.length()];
            }
            callback.write(httpBuffer.buff);
            OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());
            out.write(httpBuffer.buff, 0, callback.length());
            out.flush();
            out.close();
            this.inflightExchanges.remove(id);
            exchange.close();
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().contains("aborted") || e.getMessage().contains("forcibly") || e.getMessage().contains("pipe") || e.getMessage().contains("reset") || e.getMessage().contains("headers"))) {
                App.logger.debug("Skipping exception", (Throwable)e);
                return;
            }
            App.logger.error("ERROR", (Throwable)e);
            exchange.close();
        }
        finally {
            this.httpBuffers.add(httpBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsg(MessageType msg, long id, byte[] inData) throws Exception {
        if (!this.inflightLatencies.containsKey(id)) {
            App.logger.debug("exiting request because no ID latency map could be found. Request: " + String.valueOf(this.inflightRequests.get(id)));
            return;
        }
        byte[] data = Arrays.copyOfRange(inData, 0, inData.length);
        HttpBuffer httpBuffer = this.httpBuffers.take();
        RestQueryMessage callback = httpBuffer.callback;
        long latency = System.currentTimeMillis() - this.inflightLatencies.remove(id);
        HttpExchange exchange = this.inflightExchanges.get(id);
        httpBuffer.callback.setNextPage("null");
        try {
            FITReader fr = new FITReader();
            fr.open(data);
            int[] fmtRaw = fr.readTick().data();
            DataType[] format = new DataType[fmtRaw.length];
            for (int i = 0; i < fmtRaw.length; ++i) {
                format[i] = DataType.from(fmtRaw[i]);
            }
            boolean hasPriceType = false;
            for (DataType dataType : format) {
                if (dataType != DataType.PRICE_TYPE) continue;
                hasPriceType = true;
                break;
            }
            DataType[] headerFormat = new DataType[hasPriceType ? fmtRaw.length - 1 : fmtRaw.length];
            int index = 0;
            int pIndex = -1;
            for (DataType d : format) {
                if (d != DataType.PRICE_TYPE) {
                    headerFormat[index++] = d;
                    continue;
                }
                pIndex = index;
            }
            DataRequest dataRequest = this.inflightRequests.get(id);
            if (dataRequest != null && dataRequest.hasArg(ReqArg.USE_CSV) && dataRequest.getBoolean(ReqArg.USE_CSV)) {
                callback.toCSV(headerFormat, format, fr, pIndex);
                exchange.getResponseHeaders().set("Content-Type", "application/csv");
                exchange.getResponseHeaders().add("Content-Disposition", "attachment; filename=" + dataRequest.toNiceString() + ".csv;");
            } else {
                Tick t2;
                callback.readHeader(id, latency, msg, headerFormat);
                callback.start();
                while ((t2 = fr.readTick()) != null) {
                    callback.addTick(format, t2.data(), pIndex);
                }
                callback.end();
                exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
            }
            exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
            exchange.sendResponseHeaders(200, callback.length());
            if (callback.length() > httpBuffer.buff.length) {
                httpBuffer.buff = new char[callback.length()];
                httpBuffer.sendBuff = new byte[callback.length()];
            }
            callback.write(httpBuffer.buff);
            OutputStream out = exchange.getResponseBody();
            int writeLim = callback.length();
            for (int i = 0; i < writeLim; ++i) {
                httpBuffer.sendBuff[i] = (byte)httpBuffer.buff[i];
            }
            out.write(httpBuffer.sendBuff, 0, writeLim);
            out.flush();
            out.close();
            this.inflightExchanges.remove(id);
            this.inflightRequests.remove(id);
            exchange.close();
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().contains("aborted") || e.getMessage().contains("forcibly") || e.getMessage().contains("pipe") || e.getMessage().contains("reset") || e.getMessage().contains("headers"))) {
                App.logger.debug("Skipping exception", (Throwable)e);
                return;
            }
            this.sendError(ErrorMsg.TERMINAL_PARSE, id, "View log file for more information: " + String.valueOf(e), exchange);
            App.logger.error("ERROR", (Throwable)e);
            if (exchange != null) {
                App.logger.debug("Null exchange for request ID: " + id);
            } else {
                exchange.close();
            }
        }
        finally {
            this.httpBuffers.add(httpBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsgBulk(MessageType msg, long id, byte[] inData) throws Exception {
        if (!this.inflightLatencies.containsKey(id)) {
            App.logger.debug("exiting request because no ID latency map could be found. Request: " + String.valueOf(this.inflightRequests.get(id)));
            return;
        }
        long latency = System.currentTimeMillis() - this.inflightLatencies.remove(id);
        byte[] data = Arrays.copyOfRange(inData, 0, inData.length);
        HttpBuffer httpBuffer = this.httpBuffers.take();
        RestQueryMessage callback = httpBuffer.callback;
        HttpExchange exchange = this.inflightExchanges.get(id);
        FITReader fr = new FITReader();
        httpBuffer.callback.setNextPage("null");
        try {
            ByteBuffer bb = ByteBuffer.wrap(data);
            byte[] fmtData = new byte[bb.get()];
            bb.get(fmtData);
            fr.open(fmtData);
            int[] fmtRaw = fr.readTick().data();
            DataType[] format = new DataType[fmtRaw.length];
            for (int i = 0; i < fmtRaw.length; ++i) {
                format[i] = DataType.from(fmtRaw[i]);
            }
            boolean hasPriceType = false;
            for (DataType dataType : format) {
                if (dataType != DataType.PRICE_TYPE) continue;
                hasPriceType = true;
                break;
            }
            DataType[] headerFormat = new DataType[hasPriceType ? fmtRaw.length - 1 : fmtRaw.length];
            int index = 0;
            int pIndex = -1;
            for (DataType d : format) {
                if (d != DataType.PRICE_TYPE) {
                    headerFormat[index++] = d;
                    continue;
                }
                pIndex = index;
            }
            callback.readHeader(id, latency, msg, headerFormat);
            callback.start();
            Contract contract = new Contract(false);
            while (bb.hasRemaining()) {
                byte[] temp = new byte[bb.get()];
                bb.get(temp);
                contract.fromBytes(temp, 0, temp.length);
                byte[] tickData = new byte[bb.get()];
                bb.get(tickData);
                fr.open(tickData);
                callback.addContractTick(format, fr.readTick().data(), pIndex, contract);
            }
            callback.end();
            exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
            exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
            exchange.sendResponseHeaders(200, callback.length());
            if (callback.length() > httpBuffer.buff.length) {
                httpBuffer.buff = new char[callback.length()];
                httpBuffer.sendBuff = new byte[callback.length()];
            }
            callback.write(httpBuffer.buff);
            OutputStream out = exchange.getResponseBody();
            int writeLim = callback.length();
            for (int i = 0; i < writeLim; ++i) {
                httpBuffer.sendBuff[i] = (byte)httpBuffer.buff[i];
            }
            out.write(httpBuffer.sendBuff, 0, writeLim);
            out.flush();
            out.close();
            this.inflightExchanges.remove(id);
            exchange.close();
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().contains("aborted") || e.getMessage().contains("forcibly") || e.getMessage().contains("pipe") || e.getMessage().contains("reset") || e.getMessage().contains("headers"))) {
                App.logger.debug("Skipping exception", (Throwable)e);
                return;
            }
            this.sendError(ErrorMsg.TERMINAL_PARSE, id, "View log file for more information: " + String.valueOf(e), exchange);
            App.logger.error("ERROR", (Throwable)e);
            if (exchange != null) {
                App.logger.debug("Null exchange for request ID: " + id);
            } else {
                exchange.close();
            }
        }
        finally {
            this.httpBuffers.add(httpBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsgBulkHist(MessageType msg, long id, byte[] inData) throws Exception {
        if (!this.inflightLatencies.containsKey(id)) {
            App.logger.debug("exiting request because no ID latency map could be found. Request: " + String.valueOf(this.inflightRequests.get(id)));
            return;
        }
        long latency = System.currentTimeMillis() - this.inflightLatencies.remove(id);
        byte[] data = Arrays.copyOfRange(inData, 0, inData.length);
        HttpBuffer httpBuffer = this.httpBuffers.take();
        RestQueryMessage callback = httpBuffer.callback;
        HttpExchange exchange = this.inflightExchanges.get(id);
        FITReader fr = new FITReader();
        httpBuffer.callback.setNextPage("null");
        try {
            ByteBuffer bb = ByteBuffer.wrap(data);
            byte[] fmtData = new byte[bb.get()];
            bb.get(fmtData);
            fr.open(fmtData);
            int[] fmtRaw = fr.readTick().data();
            DataType[] format = new DataType[fmtRaw.length];
            for (int i = 0; i < fmtRaw.length; ++i) {
                format[i] = DataType.from(fmtRaw[i]);
            }
            boolean hasPriceType = false;
            for (DataType dataType : format) {
                if (dataType != DataType.PRICE_TYPE) continue;
                hasPriceType = true;
                break;
            }
            DataType[] headerFormat = new DataType[hasPriceType ? fmtRaw.length - 1 : fmtRaw.length];
            int index = 0;
            int pIndex = -1;
            for (DataType d : format) {
                if (d != DataType.PRICE_TYPE) {
                    headerFormat[index++] = d;
                    continue;
                }
                pIndex = index;
            }
            callback.readHeader(id, latency, msg, headerFormat);
            callback.start();
            Contract contract = new Contract(false);
            while (bb.hasRemaining()) {
                byte[] temp = new byte[bb.get()];
                bb.get(temp);
                contract.fromBytes(temp, 0, temp.length);
                byte[] tickData = new byte[bb.getInt()];
                bb.get(tickData);
                fr.open(tickData);
                callback.addContractTicks(format, fr, pIndex, contract);
            }
            callback.end();
            exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
            exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
            exchange.sendResponseHeaders(200, callback.length());
            if (callback.length() > httpBuffer.buff.length) {
                httpBuffer.buff = new char[callback.length()];
                httpBuffer.sendBuff = new byte[callback.length()];
            }
            callback.write(httpBuffer.buff);
            OutputStream out = exchange.getResponseBody();
            int writeLim = callback.length();
            for (int i = 0; i < writeLim; ++i) {
                httpBuffer.sendBuff[i] = (byte)httpBuffer.buff[i];
            }
            out.write(httpBuffer.sendBuff, 0, writeLim);
            out.flush();
            out.close();
            this.inflightExchanges.remove(id);
            exchange.close();
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().contains("aborted") || e.getMessage().contains("forcibly") || e.getMessage().contains("pipe") || e.getMessage().contains("reset") || e.getMessage().contains("headers"))) {
                App.logger.debug("Skipping exception", (Throwable)e);
                return;
            }
            App.logger.error("ERROR", (Throwable)e);
            this.sendError(ErrorMsg.TERMINAL_PARSE, id, "View log file for more information: " + String.valueOf(e), exchange);
            if (exchange != null) {
                App.logger.debug("Null exchange for request ID: " + id);
            } else {
                exchange.close();
            }
        }
        finally {
            this.httpBuffers.add(httpBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendContractBulk(MessageType msg, long id, byte[] inData) throws Exception {
        long latency = System.currentTimeMillis() - this.inflightLatencies.remove(id);
        byte[] data = Arrays.copyOfRange(inData, 0, inData.length);
        HttpBuffer httpBuffer = this.httpBuffers.take();
        RestQueryMessage callback = httpBuffer.callback;
        HttpExchange exchange = this.inflightExchanges.get(id);
        httpBuffer.callback.setNextPage("null");
        ByteArrayInputStream bs = new ByteArrayInputStream(data);
        GZIPInputStream gin = new GZIPInputStream(bs);
        byte[] contracts = gin.readAllBytes();
        gin.close();
        try {
            callback.readHeader(id, latency, msg, null);
            callback.start("[\"root\",\"expiration\",\"strike\",\"right\"]");
            Contract con = new Contract(false);
            for (int pos = 0; pos < contracts.length; pos += contracts[pos]) {
                con.fromBytes(contracts, pos, contracts[pos]);
                callback.addContractListFast(con);
            }
            callback.end();
            exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
            exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
            exchange.sendResponseHeaders(200, callback.length());
            if (callback.length() > httpBuffer.buff.length) {
                httpBuffer.buff = new char[callback.length()];
                httpBuffer.sendBuff = new byte[callback.length()];
            }
            callback.write(httpBuffer.buff);
            OutputStream out = exchange.getResponseBody();
            int writeLim = callback.length();
            for (int i = 0; i < writeLim; ++i) {
                httpBuffer.sendBuff[i] = (byte)httpBuffer.buff[i];
            }
            out.write(httpBuffer.sendBuff, 0, writeLim);
            out.flush();
            out.close();
            this.inflightExchanges.remove(id);
            exchange.close();
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().contains("aborted") || e.getMessage().contains("forcibly") || e.getMessage().contains("pipe") || e.getMessage().contains("reset") || e.getMessage().contains("headers"))) {
                App.logger.debug("Skipping exception", (Throwable)e);
                return;
            }
            this.sendError(ErrorMsg.TERMINAL_PARSE, id, "View log file for more information: " + String.valueOf(e), exchange);
            App.logger.error("ERROR", (Throwable)e);
            if (exchange != null) {
                exchange.close();
            }
        }
        finally {
            this.httpBuffers.add(httpBuffer);
        }
    }

    private void registerHistsV2() {
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                String prefix = "/v2/hist/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    if (this.checkPath(prefix, exchange)) {
                        return;
                    }
                    long id = -1L;
                    try {
                        if (!this.singleIPCheck(exchange)) {
                            return;
                        }
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + "&version=2" + (!queryArgs.contains("ivl=") ? "&ivl=0" : "");
                        DataRequest req = new DataRequest(MessageType.HIST, 0L, args);
                        id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightRequests.put(id, req);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                            this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.debug(Utils.getTrace(e));
                        this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
                    }
                });
            }
        }
    }

    private void registerMiscV2() {
        String prefix;
        this.server.createContext("/v2/list/roots", exchange -> {
            long id = -1L;
            try {
                if (this.checkPath("/v2/list/roots", exchange)) {
                    return;
                }
                if (!this.singleIPCheck(exchange)) {
                    return;
                }
                URI uri = exchange.getRequestURI();
                String path = uri.getPath();
                String queryArgs = uri.getQuery();
                String sec = path.split("/")[4];
                String args = queryArgs != null ? "sec=" + sec + "&" + queryArgs + "&version=2" : "sec=" + sec + "&version=2";
                DataRequest req = new DataRequest(MessageType.ALL_ROOTS, 0L, args);
                id = req.getId();
                this.inflightExchanges.put(id, exchange);
                this.inflightRequests.put(id, req);
                this.inflightLatencies.put(id, System.currentTimeMillis());
                if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                    this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                }
            }
            catch (Exception e) {
                App.logger.debug(Utils.getTrace(e));
                this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
            }
        });
        this.server.createContext("/v2/list/expirations", exchange -> {
            if (this.checkPath("/v2/list/expirations", exchange)) {
                return;
            }
            long id = -1L;
            try {
                String queryArgs = exchange.getRequestURI().getQuery();
                String args = queryArgs + "&version=2";
                DataRequest req = new DataRequest(MessageType.ALL_EXPIRATIONS, 0L, args);
                id = req.getId();
                this.inflightExchanges.put(id, exchange);
                this.inflightRequests.put(id, req);
                this.inflightLatencies.put(id, System.currentTimeMillis());
                if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                    this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                }
            }
            catch (Exception e) {
                App.logger.debug(Utils.getTrace(e));
                this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
            }
        });
        this.server.createContext("/v2/list/strikes", exchange -> {
            if (this.checkPath("/v2/list/strikes", exchange)) {
                return;
            }
            long id = -1L;
            try {
                String queryArgs = exchange.getRequestURI().getQuery();
                String args = queryArgs + "&version=2";
                DataRequest req = new DataRequest(MessageType.ALL_STRIKES, 0L, args);
                id = req.getId();
                this.inflightExchanges.put(id, exchange);
                this.inflightRequests.put(id, req);
                this.inflightLatencies.put(id, System.currentTimeMillis());
                if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                    this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                }
            }
            catch (Exception e) {
                App.logger.debug(Utils.getTrace(e));
                this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
            }
        });
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                prefix = "/v2/list/dates/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    if (this.checkPath(prefix, exchange)) {
                        return;
                    }
                    long id = -1L;
                    try {
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "") + "&version=2";
                        DataRequest req = new DataRequest(args.contains("strike") && sec == SecType.OPTION ? MessageType.ALL_DATES : MessageType.ALL_DATES_BULK, 0L, args);
                        id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightRequests.put(id, req);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                            this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.debug(Utils.getTrace(e));
                        this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
                    }
                });
            }
        }
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                prefix = "/v2/at_time/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    if (this.checkPath(prefix, exchange)) {
                        return;
                    }
                    long id = -1L;
                    try {
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "") + "&version=2";
                        DataRequest req = new DataRequest(MessageType.AT_TIME, 0L, args);
                        id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightRequests.put(id, req);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                            this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.debug(Utils.getTrace(e));
                        this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
                    }
                });
            }
        }
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                prefix = "/v2/bulk_at_time/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    if (this.checkPath(prefix, exchange)) {
                        return;
                    }
                    long id = -1L;
                    try {
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "") + "&version=2";
                        DataRequest req = new DataRequest(MessageType.AT_TIME_BULK, 0L, args);
                        id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightRequests.put(id, req);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                            this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.debug(Utils.getTrace(e));
                        this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
                    }
                });
            }
        }
    }

    private void registerSnapshotsV2() {
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                String prefix = "/v2/snapshot/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    long id = -1L;
                    try {
                        if (!this.singleIPCheck(exchange)) {
                            return;
                        }
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "") + "&version=2";
                        DataRequest req = new DataRequest(MessageType.LAST, 0L, args);
                        id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightRequests.put(id, req);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                            this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.debug(Utils.getTrace(e));
                        this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
                    }
                });
            }
        }
    }

    private void registerBulkSnapshotsV2() {
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                String prefix = "/v2/bulk_snapshot/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    long id = -1L;
                    try {
                        if (!this.singleIPCheck(exchange)) {
                            return;
                        }
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "") + "&version=2";
                        DataRequest req = new DataRequest(MessageType.LAST_BULK, 0L, args);
                        id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightRequests.put(id, req);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                            this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.debug(Utils.getTrace(e));
                        this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
                    }
                });
            }
        }
    }

    private void registerBulkHistV2() {
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                String prefix = "/v2/bulk_hist/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    long id = -1L;
                    try {
                        if (!this.singleIPCheck(exchange)) {
                            return;
                        }
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "") + "&version=2";
                        DataRequest req = new DataRequest(MessageType.HIST_BULK, 0L, args);
                        id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        this.inflightRequests.put(id, req);
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                            this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.debug(Utils.getTrace(e));
                        this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
                    }
                });
            }
        }
    }

    private void registerFilesV2() {
        for (SecType sec : SecType.values()) {
            for (ReqType r : ReqType.values()) {
                String prefix = "/v2/file/" + sec.name().toLowerCase() + "/" + r.name().toLowerCase();
                this.server.createContext(prefix, exchange -> {
                    long id = -1L;
                    try {
                        if (!this.singleIPCheck(exchange)) {
                            return;
                        }
                        String queryArgs = exchange.getRequestURI().getQuery();
                        String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)sec) + (!queryArgs.contains("rth=") ? "&rth=true" : "") + (!queryArgs.contains("ivl=") ? "&ivl=0" : "") + "&version=2";
                        DataRequest req = new DataRequest(MessageType.FLAT_FILE, 0L, args);
                        id = req.getId();
                        this.inflightExchanges.put(id, exchange);
                        this.inflightLatencies.put(id, System.currentTimeMillis());
                        this.inflightRequests.put(id, req);
                        FileBuilder.putRequestInfo(id, req);
                        if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                            this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                        }
                    }
                    catch (Exception e) {
                        App.logger.debug(Utils.getTrace(e));
                        this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
                    }
                });
            }
        }
    }

    private void registerBulkContractV2() {
        for (ReqType r : ReqType.values()) {
            String prefix = "/v2/list/contracts/option/" + r.name().toLowerCase();
            this.server.createContext(prefix, exchange -> {
                long id = -1L;
                try {
                    if (!this.singleIPCheck(exchange)) {
                        return;
                    }
                    String queryArgs = exchange.getRequestURI().getQuery();
                    String args = queryArgs + "&REQ=" + r.code() + "&SEC=" + String.valueOf((Object)SecType.OPTION) + "&version=2";
                    DataRequest req = new DataRequest(MessageType.CONTRACT_BULK, 0L, args);
                    id = req.getId();
                    this.inflightExchanges.put(id, exchange);
                    this.inflightLatencies.put(id, System.currentTimeMillis());
                    this.inflightRequests.put(id, req);
                    if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                        this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                    }
                }
                catch (Exception e) {
                    App.logger.debug(Utils.getTrace(e));
                    this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
                }
            });
        }
    }

    private void registerSystemCmdsV2() {
        this.server.createContext("/v2/system/mdds/status", exchange -> {
            try {
                if (!this.singleIPCheck(exchange)) {
                    return;
                }
                exchange.getResponseHeaders().set("Content-Type", "text/plain");
                exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
                if (App.getMdds() == null || !App.getMdds().isConnected()) {
                    exchange.sendResponseHeaders(200, "DISCONNECTED".getBytes().length);
                    exchange.getResponseBody().write("DISCONNECTED".getBytes());
                } else if (!App.getMdds().isVerified()) {
                    exchange.sendResponseHeaders(200, "UNVERIFIED".getBytes().length);
                    exchange.getResponseBody().write("UNVERIFIED".getBytes());
                } else {
                    exchange.sendResponseHeaders(200, "CONNECTED".getBytes().length);
                    exchange.getResponseBody().write("CONNECTED".getBytes());
                }
                exchange.close();
            }
            catch (Exception e) {
                App.logger.error("ERROR", (Throwable)e);
                exchange.getResponseHeaders().set("Content-Type", CSV_TYPE);
                exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
                exchange.sendResponseHeaders(200, "ERROR".getBytes().length);
                exchange.getResponseBody().write("ERROR".getBytes());
            }
        });
        this.server.createContext("/v2/system/fpss/status", exchange -> {
            try {
                if (!this.singleIPCheck(exchange)) {
                    return;
                }
                exchange.getResponseHeaders().set("Content-Type", "text/plain");
                exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
                if (App.getStreamClient() == null || !App.getStreamClient().isConnected()) {
                    exchange.sendResponseHeaders(200, "DISCONNECTED".getBytes().length);
                    exchange.getResponseBody().write("DISCONNECTED".getBytes());
                } else if (!App.getStreamClient().isVerified()) {
                    exchange.sendResponseHeaders(200, "UNVERIFIED".getBytes().length);
                    exchange.getResponseBody().write("UNVERIFIED".getBytes());
                } else {
                    exchange.sendResponseHeaders(200, "CONNECTED".getBytes().length);
                    exchange.getResponseBody().write("CONNECTED".getBytes());
                }
                exchange.close();
            }
            catch (Exception e) {
                App.logger.error("ERROR", (Throwable)e);
                exchange.getResponseHeaders().set("Content-Type", CSV_TYPE);
                exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
                exchange.sendResponseHeaders(200, "ERROR".getBytes().length);
                exchange.getResponseBody().write("ERROR".getBytes());
            }
        });
        this.server.createContext("/v2/system/terminal/shutdown", exchange -> {
            try {
                if (!this.singleIPCheck(exchange)) {
                    return;
                }
                exchange.getResponseHeaders().set("Content-Type", "text/plain");
                exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
                exchange.sendResponseHeaders(200, "TBD".getBytes().length);
                exchange.getResponseBody().write("TBD".getBytes());
                exchange.close();
                ExecutorService exec = Executors.newFixedThreadPool(1);
                exec.submit(() -> {
                    App.logger.warn("Received shutdown request from " + exchange.getRemoteAddress().getHostName());
                    App.logger.error("Shutting down...");
                });
                exec.awaitTermination(1L, TimeUnit.SECONDS);
                System.exit(0);
            }
            catch (Exception e) {
                App.logger.error("ERROR", (Throwable)e);
                exchange.getResponseHeaders().set("Content-Type", CSV_TYPE);
                exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
                exchange.sendResponseHeaders(200, "ERROR".getBytes().length);
                exchange.getResponseBody().write("ERROR".getBytes());
            }
        });
        this.server.createContext("/v2/system/terminal/clear_http_cache", exchange -> {
            try {
                if (!this.singleIPCheck(exchange)) {
                    return;
                }
                exchange.getResponseHeaders().set("Content-Type", "text/plain");
                exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
                exchange.sendResponseHeaders(200, "TBD".getBytes().length);
                exchange.getResponseBody().write("TBD".getBytes());
                exchange.close();
            }
            catch (Exception e) {
                App.logger.error("ERROR", (Throwable)e);
                exchange.getResponseHeaders().set("Content-Type", CSV_TYPE);
                exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
                exchange.sendResponseHeaders(200, "ERROR".getBytes().length);
                exchange.getResponseBody().write("ERROR".getBytes());
            }
        });
        this.server.createContext("/v2/system/subscriptions", exchange -> {
            try {
                if (!this.singleIPCheck(exchange)) {
                    return;
                }
                exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
                exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
                MDDSClient mdds = App.getMdds();
                if (mdds == null || !mdds.isConnected()) {
                    exchange.sendResponseHeaders(200, "DISCONNECTED".getBytes().length);
                    exchange.getResponseBody().write("DISCONNECTED".getBytes());
                } else if (!mdds.isVerified()) {
                    exchange.sendResponseHeaders(200, "UNVERIFIED".getBytes().length);
                    exchange.getResponseBody().write("UNVERIFIED".getBytes());
                } else {
                    String permString = mdds.getPerms();
                    String[] perms = permString.split(", ");
                    StringBuilder responseBuilder = new StringBuilder();
                    responseBuilder.append('{');
                    for (String perm : perms) {
                        String[] typeSub = perm.split("\\.");
                        responseBuilder.append('\"');
                        responseBuilder.append(typeSub[0]);
                        responseBuilder.append("\":\"");
                        responseBuilder.append(typeSub[1]);
                        responseBuilder.append("\",");
                    }
                    if (responseBuilder.length() > 1) {
                        responseBuilder.replace(responseBuilder.length() - 1, responseBuilder.length(), "}");
                    } else {
                        responseBuilder.append('}');
                    }
                    byte[] response = responseBuilder.toString().getBytes();
                    exchange.sendResponseHeaders(200, response.length);
                    exchange.getResponseBody().write(response);
                }
                exchange.close();
            }
            catch (Exception e) {
                App.logger.error("ERROR", (Throwable)e);
                exchange.getResponseHeaders().set("Content-Type", "text/plain");
                exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
                exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
                exchange.sendResponseHeaders(200, "ERROR".getBytes().length);
                exchange.getResponseBody().write("ERROR".getBytes());
            }
        });
    }

    private void registerPagerV2() {
        this.server.createContext("/v2/page", exchange -> {
            HttpBuffer httpBuffer;
            try {
                httpBuffer = this.httpBuffers.take();
            }
            catch (Exception e) {
                App.logger.debug("Unexpected exception with httpBuffer take ", (Throwable)e);
                return;
            }
            try {
                if (!this.singleIPCheck(exchange)) {
                    return;
                }
                long pageID = Long.parseLong(exchange.getRequestURI().toString().split("/")[3]);
                PageInfo p = this.pageMeta.get(pageID);
                if (p == null) {
                    exchange.sendResponseHeaders(477, 0L);
                    exchange.close();
                    return;
                }
                switch (p.request.getMsgType()) {
                    case HIST: {
                        this.buildPage(p.request, p.format, p.headerFormat, p.reader, p.pIndex, exchange, 0L, httpBuffer);
                        return;
                    }
                    case HIST_BULK: {
                        this.buildPageBulk(p.request, p.format, p.headerFormat, p.reader, p.pIndex, exchange, 0L, httpBuffer, p.buff);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                App.logger.debug(e);
                this.sendErrorV2(ErrorMsg.INVALID_PARAMS, -1L, "View log file for more information: " + String.valueOf(e), exchange);
                return;
            }
            finally {
                this.httpBuffers.add(httpBuffer);
            }
        });
    }

    private void registerDebug() {
        String prefix = "/v2/hist_raw";
        this.server.createContext("/v2/hist_raw", exchange -> {
            long id = -1L;
            try {
                String queryArgs;
                if (!this.singleIPCheck(exchange)) {
                    return;
                }
                String args = queryArgs = exchange.getRequestURI().getQuery();
                DataRequest req = new DataRequest(args);
                id = req.getId();
                this.inflightExchanges.put(id, exchange);
                this.inflightRequests.put(id, req);
                this.inflightLatencies.put(id, System.currentTimeMillis());
                if (App.getMdds() == null || !App.getMdds().isConnected() || !App.getMdds().writeV2(req, true)) {
                    this.sendErrorV2(ErrorMsg.DISCONNECTED, id, "Connection lost to Theta Data MDDS.");
                }
            }
            catch (Exception e) {
                App.logger.debug(Utils.getTrace(e));
                this.sendErrorV2(ErrorMsg.INVALID_PARAMS, id, "View log file for more information: " + String.valueOf(e), exchange);
            }
        });
    }

    private synchronized void removeExpiredPages() {
        long time = System.currentTimeMillis();
        if (this.pageMeta.size() <= this.concurrency * 2) {
            return;
        }
        Iterator iterator = ((ConcurrentHashMap.KeySetView)this.pageMeta.keySet()).iterator();
        while (iterator.hasNext()) {
            long i = (Long)iterator.next();
            if (time - this.pageMeta.get((Object)Long.valueOf((long)i)).birthTime <= this.pageExpire) continue;
            App.logger.debug("Removed page ID: {}", (Object)i);
            this.pageMeta.remove(i);
        }
    }

    private void buildPage(DataRequest req, DataType[] format, DataType[] headerFormat, FITReader fr, int pIndex, HttpExchange exchange, long latency, HttpBuffer httpBuffer) throws IOException {
        this.removeExpiredPages();
        exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
        exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
        exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
        exchange.getResponseHeaders().set("Next-Page", "null");
        exchange.getResponseHeaders().set("Latency", "" + latency);
        RestQueryMessage callback = httpBuffer.callback;
        httpBuffer.callback.setNextPage("null");
        callback.clear();
        int tickLim = req.hasArg(ReqArg.TICK_LIM) ? req.getInt(ReqArg.TICK_LIM) : Config.getInt("HTTP_TICK_LIM");
        boolean prettyTime = req.hasArg(ReqArg.PRETTY_TIME) && req.getBoolean(ReqArg.PRETTY_TIME);
        OutputStreamWriter osw = new OutputStreamWriter(new BufferedOutputStream(exchange.getResponseBody()));
        if (req.hasArg(ReqArg.USE_CSV) && req.getBoolean(ReqArg.USE_CSV)) {
            if (callback.toCSV2(headerFormat, format, fr, pIndex, tickLim, prettyTime)) {
                long pageID = this.pageIDGenerator.incrementAndGet();
                exchange.getResponseHeaders().set("Next-Page", this.paginationPrefix + "/v2/page/" + pageID);
                this.pageMeta.put(pageID, new PageInfo(fr, req, format, headerFormat, pIndex));
            }
            exchange.getResponseHeaders().set("Content-Type", CSV_TYPE);
            if (!req.hasArg(ReqArg.DL) || req.getBoolean(ReqArg.DL)) {
                exchange.getResponseHeaders().add("Content-Disposition", "attachment; filename=" + req.toNiceString() + ".csv;");
            }
            exchange.sendResponseHeaders(200, callback.length());
        } else {
            callback.readHeader2(req.getId(), latency, null, headerFormat);
            int ticksRead = 0;
            int[] timeIndices = new int[2];
            boolean isStringResponse = false;
            Arrays.fill(timeIndices, -1);
            for (int i = 0; i < format.length; ++i) {
                if (format[i].isStr()) {
                    isStringResponse = true;
                }
                if (format[i] == DataType.MS_OF_DAY) {
                    timeIndices[0] = i;
                    continue;
                }
                if (format[i] != DataType.MS_OF_DAY2) continue;
                timeIndices[1] = i;
            }
            if (isStringResponse) {
                String[] strTick;
                fr.isFirst(true);
                while ((strTick = fr.readStringTick()) != null) {
                    callback.addTickStr(format, strTick, pIndex, timeIndices, prettyTime);
                    if (ticksRead++ >= tickLim && fr.hasRemaining()) {
                        long pageID = this.pageIDGenerator.incrementAndGet();
                        exchange.getResponseHeaders().set("Next-Page", this.paginationPrefix + "/v2/page/" + pageID);
                        callback.readHeader2(req.getId(), latency, this.paginationPrefix + "/v2/page/" + pageID, headerFormat);
                        this.pageMeta.put(pageID, new PageInfo(fr, req, format, headerFormat, pIndex));
                        break;
                    }
                    fr.isFirst(true);
                }
            } else {
                Tick t2;
                while ((t2 = fr.readTick()) != null) {
                    callback.addTick2(format, t2.data(), pIndex, timeIndices, prettyTime);
                    if (ticksRead++ < tickLim || !fr.hasRemaining()) continue;
                    long pageID = this.pageIDGenerator.incrementAndGet();
                    exchange.getResponseHeaders().set("Next-Page", this.paginationPrefix + "/v2/page/" + pageID);
                    callback.readHeader2(req.getId(), latency, this.paginationPrefix + "/v2/page/" + pageID, headerFormat);
                    this.pageMeta.put(pageID, new PageInfo(fr, req, format, headerFormat, pIndex));
                    break;
                }
            }
            callback.end();
            String start = callback.getStart2();
            exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
            exchange.sendResponseHeaders(200, start.length() + callback.length());
            osw.write(start);
        }
        int writeLim = callback.length();
        if (writeLim > httpBuffer.buff.length) {
            httpBuffer.buff = new char[writeLim];
            httpBuffer.sendBuff = new byte[writeLim];
        }
        callback.write(httpBuffer.buff);
        osw.write(httpBuffer.buff, 0, writeLim);
        osw.flush();
        osw.close();
        exchange.close();
    }

    private void buildPageBulk(DataRequest req, DataType[] format, DataType[] headerFormat, FITReader fr, int pIndex, HttpExchange exchange, long latency, HttpBuffer httpBuffer, ByteBuffer bb) throws IOException {
        this.removeExpiredPages();
        exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
        exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
        exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
        exchange.getResponseHeaders().set("Next-Page", "null");
        exchange.getResponseHeaders().set("Latency", "" + latency);
        RestQueryMessage callback = httpBuffer.callback;
        callback.clear();
        boolean prettyTime = req.hasArg(ReqArg.PRETTY_TIME) && req.getBoolean(ReqArg.PRETTY_TIME);
        int tickLim = req.hasArg(ReqArg.TICK_LIM) ? req.getInt(ReqArg.TICK_LIM) : Config.getInt("HTTP_TICK_LIM");
        OutputStreamWriter osw = new OutputStreamWriter(new BufferedOutputStream(exchange.getResponseBody()));
        httpBuffer.callback.setNextPage("null");
        if (req.hasArg(ReqArg.USE_CSV) && req.getBoolean(ReqArg.USE_CSV)) {
            if (callback.toCSVBulk(headerFormat, format, fr, pIndex, tickLim, req.getSecType(), bb, req.getMsgType() == MessageType.LAST_BULK, prettyTime) && bb.hasRemaining()) {
                long pageID = this.pageIDGenerator.incrementAndGet();
                exchange.getResponseHeaders().set("Next-Page", this.paginationPrefix + "/v2/page/" + pageID);
                this.pageMeta.put(pageID, new PageInfo(fr, req, format, headerFormat, pIndex, bb));
            }
            exchange.getResponseHeaders().set("Content-Type", CSV_TYPE);
            exchange.getResponseHeaders().add("Content-Disposition", "attachment; filename=" + req.toNiceString() + ".csv;");
            exchange.sendResponseHeaders(200, callback.length());
        } else {
            callback.readHeader2(req.getId(), latency, null, headerFormat);
            Contract contract = new Contract(false);
            int ticksRead = 0;
            while (bb.hasRemaining()) {
                byte[] temp = new byte[bb.get()];
                bb.get(temp);
                contract.fromBytes(temp, 0, temp.length);
                byte[] tickData = new byte[req.getMsgType() == MessageType.LAST_BULK ? bb.get() : bb.getInt()];
                bb.get(tickData);
                fr.open(tickData);
                ticksRead += callback.addContractTicks2(format, fr, pIndex, contract, prettyTime);
                if (ticksRead++ < tickLim || !bb.hasRemaining()) continue;
                long pageID = this.pageIDGenerator.incrementAndGet();
                exchange.getResponseHeaders().set("Next-Page", this.paginationPrefix + "/v2/page/" + pageID);
                callback.readHeader2(req.getId(), latency, this.paginationPrefix + "/v2/page/" + pageID, headerFormat);
                this.pageMeta.put(pageID, new PageInfo(fr, req, format, headerFormat, pIndex, bb));
                break;
            }
            callback.end();
            String start = callback.getStart2();
            exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
            exchange.sendResponseHeaders(200, callback.length() + start.length());
            osw.write(start);
        }
        int writeLim = callback.length();
        if (writeLim > httpBuffer.buff.length) {
            httpBuffer.buff = new char[writeLim];
            httpBuffer.sendBuff = new byte[writeLim];
        }
        callback.write(httpBuffer.buff);
        osw.write(httpBuffer.buff, 0, writeLim);
        osw.flush();
        osw.close();
        exchange.close();
    }

    public void sendMsgTxt(MessageType msg, long id, String text) throws InterruptedException, IOException {
        if (!this.inflightLatencies.containsKey(id)) {
            App.logger.debug("exiting request because no ID latency map could be found. Request: {}", (Object)this.inflightRequests.get(id));
            return;
        }
        HttpExchange exchange = this.inflightExchanges.remove(id);
        exchange.getResponseHeaders().set("Content-Type", "text/plain");
        exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
        exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
        exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
        exchange.sendResponseHeaders(200, text.getBytes().length);
        exchange.getResponseBody().write(text.getBytes());
        exchange.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsgBulkHistV2(long id, byte[] data, boolean useZIP) throws Exception {
        if (!this.inflightLatencies.containsKey(id)) {
            App.logger.debug("exiting request because no ID latency map could be found. Request: {}", (Object)this.inflightRequests.get(id));
            return;
        }
        HttpBuffer httpBuffer = this.httpBuffers.take();
        HttpExchange exchange = this.inflightExchanges.remove(id);
        httpBuffer.callback.setNextPage("null");
        try {
            byte[] realData;
            long latency = System.currentTimeMillis() - this.inflightLatencies.remove(id);
            InputStream gin = null;
            if (useZIP) {
                ByteArrayInputStream bs = new ByteArrayInputStream(data);
                gin = new GZIPInputStream(bs);
            }
            byte[] byArray = realData = useZIP ? gin.readAllBytes() : data;
            if (useZIP) {
                ((GZIPInputStream)gin).close();
            }
            FITReader fr = new FITReader();
            fr.open(realData);
            ByteBuffer bb = ByteBuffer.wrap(realData);
            byte[] fmtData = new byte[bb.get()];
            bb.get(fmtData);
            fr.open(fmtData);
            int[] fmtRaw = fr.readTick().data();
            DataType[] format = new DataType[fmtRaw.length];
            for (int i = 0; i < fmtRaw.length; ++i) {
                format[i] = DataType.from(fmtRaw[i]);
            }
            boolean hasPriceType = false;
            for (DataType dataType : format) {
                if (dataType != DataType.PRICE_TYPE) continue;
                hasPriceType = true;
                break;
            }
            DataType[] headerFormat = new DataType[hasPriceType ? fmtRaw.length - 1 : fmtRaw.length];
            int index = 0;
            int pIndex = -1;
            for (DataType d : format) {
                if (d != DataType.PRICE_TYPE) {
                    headerFormat[index++] = d;
                    continue;
                }
                pIndex = index;
            }
            DataRequest dataRequest = this.inflightRequests.remove(id);
            this.buildPageBulk(dataRequest, format, headerFormat, fr, pIndex, exchange, latency, httpBuffer, bb);
        }
        catch (Exception e) {
            App.logger.debug(Utils.getTrace(e));
            this.sendErrorV2(ErrorMsg.TERMINAL_PARSE, id, "View log file for more information: " + String.valueOf(e), exchange);
        }
        finally {
            this.httpBuffers.add(httpBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsgV2(MessageType msg, long id, String[] list) throws InterruptedException {
        if (!this.inflightLatencies.containsKey(id)) {
            App.logger.debug("exiting request because no ID latency map could be found. Request: {}", (Object)this.inflightRequests.get(id));
            return;
        }
        long latency = System.currentTimeMillis() - this.inflightLatencies.remove(id);
        HttpExchange exchange = this.inflightExchanges.get(id);
        DataRequest req = this.inflightRequests.remove(id);
        HttpBuffer httpBuffer = this.httpBuffers.take();
        RestQueryMessage callback = httpBuffer.callback;
        httpBuffer.callback.setNextPage("null");
        Object[] format = new String[]{"null"};
        switch (msg) {
            case ALL_STRIKES: {
                format = new String[]{"\"strike\""};
                break;
            }
            case ALL_DATES_BULK: 
            case ALL_EXPIRATIONS: 
            case ALL_DATES: {
                format = new String[]{"\"date\""};
                break;
            }
            case ALL_ROOTS: {
                format = new String[]{"\"root\""};
            }
        }
        exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
        exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
        exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
        exchange.getResponseHeaders().set("Next-Page", "null");
        exchange.getResponseHeaders().set("Latency", "" + latency);
        try {
            if (req.hasArg(ReqArg.USE_CSV) && req.getBoolean(ReqArg.USE_CSV)) {
                callback.toCSVList((String[])format, list);
                exchange.getResponseHeaders().set("Content-Type", CSV_TYPE);
                exchange.getResponseHeaders().add("Content-Disposition", "attachment; filename=" + req.toNiceString() + ".csv;");
            } else {
                callback.readHeader2(req.getId(), latency, null, null);
                callback.start2(Arrays.toString(format));
                if (msg == MessageType.ALL_ROOTS) {
                    for (String s2 : list) {
                        callback.addStr2(s2);
                    }
                } else {
                    for (String s3 : list) {
                        callback.addInt(s3);
                    }
                }
                callback.end();
                exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
            }
            exchange.sendResponseHeaders(200, callback.length());
            if (callback.length() > httpBuffer.buff.length) {
                httpBuffer.buff = new char[callback.length()];
                httpBuffer.sendBuff = new byte[callback.length()];
            }
            callback.write(httpBuffer.buff);
            OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());
            out.write(httpBuffer.buff, 0, callback.length());
            out.flush();
            out.close();
            this.inflightExchanges.remove(id);
            exchange.close();
        }
        catch (Exception e) {
            exchange.close();
            if (e.getMessage() != null && (e.getMessage().contains("aborted") || e.getMessage().contains("forcibly") || e.getMessage().contains("pipe") || e.getMessage().contains("reset") || e.getMessage().contains("headers"))) {
                App.logger.debug("Skipping exception", (Throwable)e);
                return;
            }
            App.logger.error("ERROR", (Throwable)e);
        }
        finally {
            this.httpBuffers.add(httpBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsgV2(long id, byte[] data, boolean useZIP) throws Exception {
        if (!this.inflightLatencies.containsKey(id)) {
            App.logger.debug("exiting request because no ID latency map could be found. Request: {}", (Object)this.inflightRequests.get(id));
            return;
        }
        HttpExchange exchange = this.inflightExchanges.remove(id);
        HttpBuffer httpBuffer = this.httpBuffers.take();
        try {
            byte[] realData;
            httpBuffer.callback.setNextPage("null");
            long latency = System.currentTimeMillis() - this.inflightLatencies.remove(id);
            InputStream gin = null;
            if (useZIP) {
                ByteArrayInputStream bs = new ByteArrayInputStream(data);
                gin = new GZIPInputStream(bs);
            }
            byte[] byArray = realData = useZIP ? gin.readAllBytes() : data;
            if (useZIP) {
                ((GZIPInputStream)gin).close();
            }
            FITReader fr = new FITReader();
            fr.open(realData);
            int[] fmtRaw = fr.readTick().data();
            DataType[] format = new DataType[fmtRaw.length];
            for (int i = 0; i < fmtRaw.length; ++i) {
                format[i] = DataType.from(fmtRaw[i]);
            }
            boolean hasPriceType = false;
            for (DataType dataType : format) {
                if (dataType != DataType.PRICE_TYPE) continue;
                hasPriceType = true;
                break;
            }
            DataType[] headerFormat = new DataType[hasPriceType ? fmtRaw.length - 1 : fmtRaw.length];
            int index = 0;
            int pIndex = -1;
            for (DataType d : format) {
                if (d != DataType.PRICE_TYPE) {
                    headerFormat[index++] = d;
                    continue;
                }
                pIndex = index;
            }
            DataRequest dataRequest = this.inflightRequests.remove(id);
            this.buildPage(dataRequest, format, headerFormat, fr, pIndex, exchange, latency, httpBuffer);
        }
        catch (Exception e) {
            App.logger.debug("", (Throwable)e);
            this.sendErrorV2(ErrorMsg.TERMINAL_PARSE, id, "View log file for more information: " + String.valueOf(e), exchange);
        }
        finally {
            this.httpBuffers.add(httpBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendContractBulkV2(long id, byte[] inData) throws Exception {
        long latency = System.currentTimeMillis() - this.inflightLatencies.remove(id);
        byte[] data = Arrays.copyOfRange(inData, 0, inData.length);
        HttpBuffer httpBuffer = this.httpBuffers.take();
        RestQueryMessage callback = httpBuffer.callback;
        HttpExchange exchange = this.inflightExchanges.remove(id);
        httpBuffer.callback.setNextPage("null");
        exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
        exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
        exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
        exchange.getResponseHeaders().set("Next-Page", "null");
        exchange.getResponseHeaders().set("Latency", "" + latency);
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(data);
            GZIPInputStream gin = new GZIPInputStream(bs);
            byte[] contracts = gin.readAllBytes();
            gin.close();
            DataRequest req = this.inflightRequests.remove(id);
            if (req.hasArg(ReqArg.USE_CSV) && req.getBoolean(ReqArg.USE_CSV)) {
                callback.toCSVContracts(contracts, req.getSecType());
                exchange.getResponseHeaders().set("Content-Type", "application/csv");
                exchange.getResponseHeaders().add("Content-Disposition", "attachment; filename=" + req.toNiceString() + ".csv;");
            } else {
                callback.readHeader2(id, latency, null, null);
                callback.start("[\"root\",\"expiration\",\"strike\",\"right\"]");
                Contract con = new Contract(false);
                for (int pos = 0; pos < contracts.length; pos += contracts[pos]) {
                    con.fromBytes(contracts, pos, contracts[pos]);
                    callback.addContractListFast(con);
                }
                callback.endCSVContracts();
                exchange.getResponseHeaders().set("Content-Type", JSON_TYPE);
            }
            exchange.sendResponseHeaders(200, callback.length());
            if (callback.length() > httpBuffer.buff.length) {
                httpBuffer.buff = new char[callback.length()];
                httpBuffer.sendBuff = new byte[callback.length()];
            }
            callback.write(httpBuffer.buff);
            BufferedOutputStream out = new BufferedOutputStream(exchange.getResponseBody());
            int writeLim = callback.length();
            for (int i = 0; i < writeLim; ++i) {
                httpBuffer.sendBuff[i] = (byte)httpBuffer.buff[i];
            }
            out.write(httpBuffer.sendBuff, 0, writeLim);
            out.flush();
            out.close();
            exchange.close();
        }
        catch (Exception e) {
            App.logger.debug(Utils.getTrace(e));
            this.sendErrorV2(ErrorMsg.TERMINAL_PARSE, id, "View log file for more information: " + String.valueOf(e), exchange);
        }
        finally {
            this.httpBuffers.add(httpBuffer);
        }
    }

    public void sendErrorV2(ErrorMsg msg, long id, String info) {
        this.inflightLatencies.remove(id);
        this.inflightRequests.remove(id);
        HttpExchange exchange = this.inflightExchanges.remove(id);
        if (exchange == null) {
            App.logger.debug("Null exchange for request ID: {}. Active request IDs: {}", (Object)id, (Object)this.inflightExchanges.keySet());
            return;
        }
        try {
            exchange.getResponseHeaders().set("Content-Type", "text");
            exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
            byte[] toSend = info.getBytes(StandardCharsets.UTF_8);
            exchange.sendResponseHeaders(msg.httpErrorCode(), toSend.length);
            exchange.getResponseBody().write(toSend);
            exchange.getResponseBody().flush();
            exchange.getResponseBody().close();
            exchange.close();
        }
        catch (Exception e) {
            App.logger.debug(Utils.getTrace(e));
            if (e.getMessage() != null && (e.getMessage().contains("aborted") || e.getMessage().contains("forcibly") || e.getMessage().contains("pipe") || e.getMessage().contains("reset") || e.getMessage().contains("headers"))) {
                App.logger.debug("Skipping exception", (Throwable)e);
                return;
            }
            App.logger.error("ERROR", (Throwable)e);
            exchange.close();
        }
    }

    public void sendErrorV2(ErrorMsg msg, long id, String info, HttpExchange exchange) {
        App.logger.debug("sending error v2: {} id: {} info: {}", (Object)msg, (Object)id, (Object)info);
        this.inflightLatencies.remove(id);
        this.inflightRequests.remove(id);
        HttpExchange tmp = this.inflightExchanges.remove(id);
        if (tmp != null) {
            tmp.close();
        }
        if (exchange == null) {
            return;
        }
        try {
            exchange.getResponseHeaders().set("Content-Type", "text");
            exchange.getResponseHeaders().set("Access-Control-Allow-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Request-Headers", controlOrigin);
            exchange.getResponseHeaders().set("Access-Control-Allow-Origin", controlOrigin);
            byte[] toSend = info.getBytes(StandardCharsets.UTF_8);
            exchange.sendResponseHeaders(msg.httpErrorCode(), toSend.length);
            exchange.getResponseBody().write(toSend);
            exchange.getResponseBody().flush();
            exchange.getResponseBody().close();
            exchange.close();
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().contains("aborted") || e.getMessage().contains("forcibly") || e.getMessage().contains("pipe") || e.getMessage().contains("reset") || e.getMessage().contains("headers"))) {
                App.logger.debug("Skipping exception", (Throwable)e);
                return;
            }
            App.logger.error("ERROR", (Throwable)e);
            exchange.close();
        }
    }

    private boolean singleIPCheck(HttpExchange exg) throws IOException {
        if (this.lastIP == null) {
            this.lastIP = exg.getRemoteAddress().getHostName();
            return true;
        }
        if (App.DISABLE_IP_LIM) {
            return true;
        }
        if (!this.lastIP.equals(exg.getRemoteAddress().getHostName())) {
            exg.sendResponseHeaders(476, 0L);
            exg.close();
            App.logger.warn("Closing HTTP connection because the IP {} differs from the accept IP of {}. You can only use one unique IP address after starting the Theta Terminal", (Object)exg.getRemoteAddress().getHostName(), (Object)this.lastIP);
            return false;
        }
        return true;
    }

    private static class HttpBuffer {
        private char[] buff = new char[0x100000];
        private byte[] sendBuff = new byte[0x100000];
        private final RestQueryMessage callback = new RestQueryMessage();

        private HttpBuffer() {
        }
    }

    private static class PageInfo {
        final FITReader reader;
        final DataRequest request;
        final DataType[] format;
        final DataType[] headerFormat;
        final int pIndex;
        final ByteBuffer buff;
        final long birthTime;

        public PageInfo(FITReader reader, DataRequest request, DataType[] format, DataType[] headerFormat, int pIndex) {
            this.reader = reader;
            this.request = request;
            this.format = format;
            this.headerFormat = headerFormat;
            this.pIndex = pIndex;
            this.buff = null;
            this.birthTime = System.currentTimeMillis();
        }

        public PageInfo(FITReader reader, DataRequest request, DataType[] format, DataType[] headerFormat, int pIndex, ByteBuffer buff) {
            this.reader = reader;
            this.request = request;
            this.format = format;
            this.headerFormat = headerFormat;
            this.pIndex = pIndex;
            this.buff = buff;
            this.birthTime = System.currentTimeMillis();
        }
    }
}

