/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.loadtest;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.thetadata.terminal.App;
import net.thetadata.terminal.api.types.MessageType;
import net.thetadata.terminal.io.Packet;
import net.thetadata.terminal.net.PacketStream;
import net.thetadata.terminal.types.DataRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MddsClient
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(MddsClient.class);
    private static final String DEFAULT_USER = "testing2@thetadata.net";
    private static final String DEFAULT_PASS = "test22";
    private final PacketStream packetStream;
    private final SSLSocket socket;

    public MddsClient(String hostname, int port) throws IOException {
        this(hostname, port, DEFAULT_USER, DEFAULT_PASS);
    }

    public MddsClient(String hostname, int port, String user, String pass) throws IOException {
        File f = new File(App.ROOT_DIR, "client.jks");
        boolean exists = f.exists();
        f.createNewFile();
        Files.write(f.toPath(), App.class.getClassLoader().getResource("client.jks").openStream().readAllBytes(), new OpenOption[0]);
        if (!exists) {
            try {
                Thread.sleep(250L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.setProperty("javax.net.ssl.trustStore", f.toString());
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        this.socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
        this.socket.setTcpNoDelay(true);
        this.socket.connect(new InetSocketAddress(hostname, port), 2000);
        this.socket.setReceiveBufferSize(0x100000);
        this.socket.startHandshake();
        this.packetStream = new PacketStream(this.socket.getInputStream(), this.socket.getOutputStream());
        logger.info("Attempting login as " + user);
        ByteBuffer out = ByteBuffer.allocate(3 + user.getBytes().length + pass.getBytes().length);
        out.put((byte)0);
        out.putShort((byte)user.getBytes().length);
        out.put(user.getBytes());
        out.put(pass.getBytes());
        this.packetStream.write(MessageType.CREDENTIALS, 1L, out);
        byte[] token = this.getResponse(MessageType.SESSION_TOKEN, -1L);
        byte[] subscriptions = this.getResponse(MessageType.METADATA, -1L);
    }

    public byte[] makeRequest(DataRequest request) throws IOException {
        this.packetStream.write(request.getMsgType(), request.getId(), ByteBuffer.wrap(request.toString().getBytes()));
        return this.getResponse(request.getMsgType(), request.getId());
    }

    private byte[] getResponse(MessageType msgType, long id) throws IOException {
        Packet packet = this.packetStream.read();
        if (id != packet.id()) {
            logger.error("Request/response id mismatch: {} != {}", (Object)id, (Object)packet.id());
        }
        if (msgType != packet.clientMsg()) {
            logger.error("Request/response msg type mismatch: {} != {}", (Object)msgType, (Object)packet.clientMsg());
        }
        return packet.data();
    }

    @Override
    public void close() throws Exception {
        this.socket.close();
    }
}

