/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.http;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Timer;
import java.util.TimerTask;
import net.thetadata.Tick;
import net.thetadata.enums.ReqType;
import net.thetadata.enums.SecType;
import net.thetadata.enums.StreamResponseType;
import net.thetadata.terminal.App;
import net.thetadata.terminal.Contract;
import net.thetadata.terminal.api.types.TradeRef;
import net.thetadata.terminal.api.utils.PriceCalc;
import net.thetadata.terminal.http.QuoteRef;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class WSEvents
extends WebSocketAdapter {
    private static final Logger logger = LogManager.getLogger(WSEvents.class);
    private Session session;
    private final StringBuilder priceBuilder = new StringBuilder();
    private final TradeRef tRef = new TradeRef(new Tick(7));
    private final QuoteRef qRef = new QuoteRef(new Tick(11));
    private static volatile Timer pinger;
    private final Object mutex = new Object();
    private final JsonObject pingHeaderObj = new JsonObject();
    private final JsonObject pingObj = new JsonObject();
    private final JsonObject obj = new JsonObject();
    private final JsonObject headerObj = new JsonObject();
    private final JsonObject tradeObj = new JsonObject();
    private final JsonObject quoteObj = new JsonObject();
    private final JsonObject ohlcObj = new JsonObject();
    private final JsonObject conObject = new JsonObject();
    volatile int flushCount = 0;

    public WSEvents() {
        this.obj.add("header", this.headerObj);
        this.headerObj.addProperty("type", "STATUS");
        this.headerObj.addProperty("status", "CONNECTED");
        this.obj.add("contract", this.conObject);
        this.obj.add("quote", this.quoteObj);
        this.obj.add("trade", this.tradeObj);
        this.obj.add("ohlc", this.ohlcObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleTrade(Contract c, Tick t2) {
        if (this.session == null) {
            return true;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.tRef.read(t2);
            this.readContract(c);
            this.obj.add("contract", this.conObject);
            this.priceBuilder.setLength(0);
            this.obj.remove("quote");
            this.obj.remove("ohlc");
            this.obj.add("trade", this.tradeObj);
            this.headerObj.addProperty("type", "TRADE");
            this.tradeObj.addProperty("ms_of_day", this.tRef.getMsOfDay());
            this.tradeObj.addProperty("sequence", this.tRef.getSeq());
            this.tradeObj.addProperty("size", this.tRef.getSize());
            this.tradeObj.addProperty("condition", this.tRef.getCondition());
            PriceCalc.fmtPrice(this.priceBuilder, PriceCalc.getPriceDouble(this.tRef.getPrice(), this.tRef.getPriceType()), PriceCalc.PLACES[this.tRef.getPriceType()]);
            this.tradeObj.addProperty("price", Double.valueOf(this.priceBuilder.toString()));
            this.tradeObj.addProperty("exchange", this.tRef.getExchange());
            this.tradeObj.addProperty("date", this.tRef.getDate());
            this.flush();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePingAndFlush() {
        Object object = this.mutex;
        synchronized (object) {
            String status = "ERROR";
            try {
                status = App.getStreamClient() == null || !App.getStreamClient().isConnected() ? "DISCONNECTED" : (!App.getStreamClient().isVerified() ? "UNVERIFIED" : "CONNECTED");
            }
            catch (Exception e) {
                logger.debug("Exception while handling ping-and-flush", (Throwable)e);
            }
            this.obj.remove("trade");
            this.obj.remove("ohlc");
            this.obj.remove("quote");
            this.obj.remove("contract");
            this.obj.add("header", this.headerObj);
            this.headerObj.addProperty("type", "STATUS");
            this.headerObj.addProperty("status", status);
            if (!status.equals("CONNECTED")) {
                logger.debug("Sending status: {}", (Object)this.obj);
            }
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reqResponse(int id, StreamResponseType type) {
        Object object = this.mutex;
        synchronized (object) {
            this.obj.remove("trade");
            this.obj.remove("ohlc");
            this.obj.remove("quote");
            this.obj.remove("contract");
            this.obj.add("header", this.headerObj);
            this.headerObj.addProperty("type", "REQ_RESPONSE");
            this.headerObj.addProperty("response", type != null ? type.name() : StreamResponseType.ERROR.name());
            this.headerObj.addProperty("req_id", id);
            this.flush();
            this.headerObj.remove("req_id");
            this.headerObj.remove("response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void state(String state) {
        Object object = this.mutex;
        synchronized (object) {
            this.obj.remove("trade");
            this.obj.remove("ohlc");
            this.obj.remove("quote");
            this.obj.remove("contract");
            this.obj.add("header", this.headerObj);
            this.headerObj.addProperty("type", "STATE");
            this.headerObj.addProperty("state", state);
            this.flush();
            this.headerObj.remove("state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readOHLC(Contract c, Tick t2, boolean clearChildren) {
        if (this.session == null) {
            return true;
        }
        Object object = this.mutex;
        synchronized (object) {
            int[] data = t2.data();
            this.readContract(c);
            this.obj.add("contract", this.conObject);
            this.priceBuilder.setLength(0);
            this.obj.remove("quote");
            this.obj.remove("trade");
            this.obj.add("ohlc", this.ohlcObj);
            this.headerObj.addProperty("type", "OHLC");
            this.ohlcObj.addProperty("ms_of_day", t2.data()[0]);
            PriceCalc.fmtPrice(this.priceBuilder, PriceCalc.getPriceDouble(data[1], data[7]), PriceCalc.PLACES[data[7]]);
            this.ohlcObj.addProperty("open", Double.valueOf(this.priceBuilder.toString()));
            this.priceBuilder.setLength(0);
            PriceCalc.fmtPrice(this.priceBuilder, PriceCalc.getPriceDouble(data[2], data[7]), PriceCalc.PLACES[data[7]]);
            this.ohlcObj.addProperty("high", Double.valueOf(this.priceBuilder.toString()));
            this.priceBuilder.setLength(0);
            PriceCalc.fmtPrice(this.priceBuilder, PriceCalc.getPriceDouble(data[3], data[7]), PriceCalc.PLACES[data[7]]);
            this.ohlcObj.addProperty("low", Double.valueOf(this.priceBuilder.toString()));
            this.priceBuilder.setLength(0);
            PriceCalc.fmtPrice(this.priceBuilder, PriceCalc.getPriceDouble(data[4], data[7]), PriceCalc.PLACES[data[7]]);
            this.ohlcObj.addProperty("close", Double.valueOf(this.priceBuilder.toString()));
            this.priceBuilder.setLength(0);
            this.ohlcObj.addProperty("volume", data[5]);
            this.ohlcObj.addProperty("count", data[6]);
            this.ohlcObj.addProperty("date", data[8]);
            this.flush();
        }
        return false;
    }

    public synchronized void flush() {
        try {
            if (this.session != null) {
                this.session.getRemote().sendString(this.obj.toString());
            }
        }
        catch (Exception e) {
            logger.debug("Error calling flush", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readQuote(Contract c, Tick t2) {
        Object object = this.mutex;
        synchronized (object) {
            this.qRef.read(t2);
            this.readContract(c);
            this.obj.add("contract", this.conObject);
            this.priceBuilder.setLength(0);
            this.obj.remove("trade");
            this.obj.remove("ohlc");
            this.obj.add("quote", this.quoteObj);
            this.headerObj.addProperty("type", "QUOTE");
            this.quoteObj.addProperty("ms_of_day", this.qRef.getMsOfDay());
            this.quoteObj.addProperty("bid_size", this.qRef.bidSize());
            this.quoteObj.addProperty("bid_exchange", this.qRef.bidExg());
            PriceCalc.fmtPrice(this.priceBuilder, PriceCalc.getPriceDouble(this.qRef.bidPrice(), this.qRef.priceType()), PriceCalc.PLACES[this.qRef.priceType()]);
            this.quoteObj.addProperty("bid", Double.valueOf(this.priceBuilder.toString()));
            this.priceBuilder.setLength(0);
            this.quoteObj.addProperty("bid_condition", this.qRef.bidCondition());
            this.quoteObj.addProperty("ask_size", this.qRef.askSize());
            this.quoteObj.addProperty("ask_exchange", this.qRef.askExg());
            PriceCalc.fmtPrice(this.priceBuilder, PriceCalc.getPriceDouble(this.qRef.askPrice(), this.qRef.priceType()), PriceCalc.PLACES[this.qRef.priceType()]);
            this.quoteObj.addProperty("ask", Double.valueOf(this.priceBuilder.toString()));
            this.priceBuilder.setLength(0);
            this.quoteObj.addProperty("ask_condition", this.qRef.askCondition());
            this.quoteObj.addProperty("date", this.qRef.getDate());
            this.flush();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readContract(Contract c) {
        Object object = this.mutex;
        synchronized (object) {
            if (c.sec == SecType.OPTION) {
                this.conObject.addProperty("security_type", c.sec.toString());
                this.conObject.addProperty("root", c.root);
                this.conObject.addProperty("expiration", c.getExp());
                this.conObject.addProperty("strike", c.getStrike());
                this.conObject.addProperty("right", c.isCall() ? "C" : "P");
            } else {
                this.conObject.addProperty("security_type", c.sec.toString());
                this.conObject.addProperty("root", c.root);
                this.conObject.remove("expiration");
                this.conObject.remove("strike");
                this.conObject.remove("right");
            }
        }
    }

    private void startPinging() {
        if (pinger != null) {
            return;
        }
        pinger = new Timer();
        pinger.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (WSEvents.this.session == null) {
                        pinger.cancel();
                        pinger = null;
                        return;
                    }
                    WSEvents.this.handlePingAndFlush();
                }
                catch (Exception e) {
                    logger.error("Error pinging the server", (Throwable)e);
                    pinger.cancel();
                    pinger = null;
                }
            }
        }, 1000L, 1000L);
    }

    @Override
    public void onWebSocketConnect(Session session) {
        logger.debug("WS Connecting");
        super.onWebSocketConnect(session);
        this.session = session;
        App.setWSEvents(this);
        this.startPinging();
    }

    @Override
    public void onWebSocketClose(int statusCode, String reason) {
        logger.debug("WS Closed: {} {}", (Object)statusCode, (Object)reason);
        this.session = null;
        super.onWebSocketClose(statusCode, reason);
    }

    @Override
    public void onWebSocketText(String message) {
        logger.debug("WS Text: {}", (Object)message);
        try {
            super.onWebSocketText(message);
            JsonObject obj = JsonParser.parseString(message).getAsJsonObject();
            if (obj.get("msg_type").getAsString().equalsIgnoreCase("STOP")) {
                App.getStreamClient().requestStop();
                return;
            }
            boolean isBulk = obj.get("msg_type").getAsString().toUpperCase().contains("BULK");
            boolean isAdd = obj.get("add").getAsBoolean();
            SecType sec = SecType.valueOf(obj.get("sec_type").getAsString().toUpperCase());
            ReqType req = ReqType.valueOf(obj.get("req_type").getAsString().toUpperCase());
            int id = obj.get("id").getAsInt();
            if (isBulk && req == ReqType.TRADE) {
                App.getStreamClient().requestFullTradeWS(sec, id, !isAdd);
            } else if (req == ReqType.QUOTE) {
                Contract c = new Contract();
                JsonObject conObj = obj.getAsJsonObject("contract");
                if (sec == SecType.OPTION) {
                    c.read(conObj.get("root").getAsString(), conObj.get("expiration").getAsInt(), conObj.get("strike").getAsInt(), conObj.get("right").getAsString().charAt(0) == 'C');
                } else {
                    c.read(conObj.get("root").getAsString(), sec);
                }
                App.getStreamClient().requestQuote(c, id, !isAdd);
            } else if (req == ReqType.TRADE) {
                Contract c = new Contract();
                JsonObject conObj = obj.getAsJsonObject("contract");
                if (sec == SecType.OPTION) {
                    c.read(conObj.get("root").getAsString(), conObj.get("expiration").getAsInt(), conObj.get("strike").getAsInt(), conObj.get("right").getAsString().charAt(0) == 'C');
                } else {
                    c.read(conObj.get("root").getAsString(), sec);
                }
                App.getStreamClient().requestTrade(c, id, !isAdd);
            }
        }
        catch (Exception e) {
            logger.error("Invalid WebSocket Message Received: ");
            logger.error(message);
            logger.error(e);
        }
    }
}

