/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.thetadata.terminal.cfg.CommandLine;
import net.thetadata.terminal.cfg.Config;
import net.thetadata.terminal.client.ClientServerV2;
import net.thetadata.terminal.client.ClientStreamServer;
import net.thetadata.terminal.http.RESTServer;
import net.thetadata.terminal.http.WSEvents;
import net.thetadata.terminal.http.WSServer;
import net.thetadata.terminal.net.FPSSClient;
import net.thetadata.terminal.net.MDDSClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class App {
    public static Logger logger = null;
    public static final String VERSION = "1.8.6";
    public static final String MIN_PYTHON_VERSION = "0.9.11";
    public static final String REV = "A";
    public static final File ROOT_DIR = new File(Config.workingDir());
    private static MDDSClient mdds;
    private static FPSSClient fpss;
    private static RESTServer restServer;
    private static WSServer wsServer;
    private static WSEvents wsEvents;
    public static volatile boolean DISABLE_IP_LIM;

    public static void main(String ... args) throws Exception {
        CommandLine cmdLine = new CommandLine();
        try {
            cmdLine.parseArgs(args);
        }
        catch (Exception e) {
            System.err.println("Failed to parse command line arguments: " + e.getMessage());
            cmdLine.printUsage();
            System.exit(1);
        }
        logger = LogManager.getLogger(App.class);
        logger.info("Starting Theta Terminal v1.8.6 Revision A...");
        logger.info("Using {} as the log directory", (Object)cmdLine.getLogDirectory().getAbsolutePath());
        logger.info("Using {} as the config file", (Object)cmdLine.getConfigFile().getAbsolutePath());
        logger.debug("Debug logging enabled!");
        Config.load(cmdLine.getConfigFile(), cmdLine.getLine());
        try {
            int http_port = Config.getInt("HTTP_PORT");
            URL url = new URL(String.format("http://127.0.0.1:%s/v2/system/terminal/shutdown", http_port));
            byte[] shutdown_bytes = url.openConnection().getInputStream().readAllBytes();
            if (new String(shutdown_bytes).equals("TBD")) {
                Thread.sleep(2000L);
            }
        }
        catch (Exception e) {
            logger.debug("Error trying to shutdown other terminals", (Throwable)e);
        }
        try {
            App.setupServers(cmdLine);
            if (!cmdLine.noMdds()) {
                new Thread(() -> {
                    try {
                        App.connectFirstMDDSClient(cmdLine.getUsername(), cmdLine.getPassword());
                    }
                    catch (IOException e) {
                        logger.error("Error creating connection to MDDS", (Throwable)e);
                    }
                }).start();
            } else {
                logger.info("MDDS disabled!");
            }
            new Thread(() -> {
                try {
                    App.connectFirstStreamClient(cmdLine.getUsername(), cmdLine.getPassword());
                }
                catch (IOException e) {
                    logger.error("Error creating connection to FPSS", (Throwable)e);
                }
            }).start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                logger.warn("Shutting down terminal");
                if (mdds != null) {
                    mdds.close();
                    restServer.shutdown();
                }
                fpss.close();
                wsServer.shutdown();
            }));
        }
        catch (Exception e) {
            System.err.println("ERROR INITIALIZING THETA TERMINAL. PLEASE CONTACT SUPPORT on https://thetadata.net or https://discord.thetadata.us");
            System.out.println("PLEASE INCLUDE THE OUTPUT BELOW:");
            System.out.println("----------------ERROR OUTPUT----------------");
            e.printStackTrace();
            System.out.println("----------------ERROR OUTPUT----------------");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
        }
    }

    private static void setupServers(CommandLine cmdLine) throws Exception {
        if (!cmdLine.noMdds()) {
            ClientServerV2.init(Config.getInt("CLIENT_PORT"));
            int httpCon = Config.getInt("HTTP_CONCURRENCY");
            if (httpCon > 32) {
                logger.warn("You are using an HTTP_CONCURRENCY value that is higher than the recommended limit of 32. This may cause excessive memory usage.");
            }
            logger.debug("HTTP_CONCURRENCY: {}", (Object)httpCon);
            restServer = new RESTServer("0.0.0.0", Config.getInt("HTTP_PORT"), Math.max(1, httpCon));
        } else {
            logger.info("MDDS disabled!");
        }
        try {
            ClientStreamServer.init(Config.getInt("STREAM_PORT"));
        }
        catch (Exception e) {
            logger.error("Unable to start stream server. This is okay as long as you are making historical requests.");
        }
        wsServer = new WSServer();
    }

    private static void connectFirstMDDSClient(String username, String password) throws IOException {
        String hosts = Config.getStr(Config.getStr("MDDS_REGION"));
        if (hosts == null) {
            hosts = Config.getStr("MDDS_NJ_HOSTS");
        }
        MDDSClient mddsClient = new MDDSClient(1000, Config.getInt("HTTP_CONCURRENCY"), hosts.split(","));
        App.setMdds(mddsClient);
        if (mddsClient.foundServer()) {
            mddsClient.login(username, password);
            mddsClient.sendVersion();
        }
    }

    private static void connectFirstStreamClient(String username, String password) throws IOException {
        String hosts = Config.getStr(Config.getStr("FPSS_REGION"));
        if (hosts == null) {
            hosts = Config.getStr("FPSS_NJ_HOSTS");
        }
        if ((fpss = new FPSSClient(hosts.split(","))).foundServer()) {
            fpss.login(username, password);
        }
    }

    public static void setMdds(MDDSClient c) {
        mdds = c;
    }

    public static MDDSClient getMdds() {
        return mdds;
    }

    public static FPSSClient getStreamClient() {
        return fpss;
    }

    public static RESTServer getRestServer() {
        return restServer;
    }

    public static WSServer getWSServer() {
        return wsServer;
    }

    public static void setWSEvents(WSEvents events) {
        wsEvents = events;
    }

    public static WSEvents getWsEvents() {
        return wsEvents;
    }

    public static void handleInvoluntaryDisconnectMDDS(MDDSClient old) {
        logger.info("[MDDS] Connection lost... Attempting to reconnect every " + Config.getInt("RECONNECT_WAIT") / 1000 + " seconds");
        String hosts = Config.getStr(Config.getStr("MDDS_REGION"));
        if (hosts == null) {
            hosts = Config.getStr("MDDS_NJ_HOSTS");
        }
        mdds = new MDDSClient(Config.getInt("HTTP_CONCURRENCY"), old);
        ExecutorService exec = Executors.newFixedThreadPool(1);
        while (true) {
            Future<Boolean> future = exec.submit(() -> {
                if (mdds.findAndConnectToServer()) {
                    mdds.login(old);
                    return true;
                }
                return false;
            });
            try {
                if (future.get(30L, TimeUnit.SECONDS).booleanValue()) {
                    exec.shutdown();
                    return;
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            try {
                Thread.sleep(Config.getInt("RECONNECT_WAIT"));
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Interrupt", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public static void handleInvoluntaryDisconnectFPSS(FPSSClient old) {
        logger.info("[FPSS] Connection lost... Attempting to reconnect every " + Config.getInt("RECONNECT_WAIT") / 1000 + " seconds");
        String hosts = Config.getStr(Config.getStr("FPSS_REGION"));
        if (hosts == null) {
            hosts = Config.getStr("FPSS_NJ_HOSTS");
        }
        fpss = new FPSSClient(old, hosts.split(","));
        ExecutorService exec = Executors.newFixedThreadPool(1);
        while (true) {
            Future<Boolean> future = exec.submit(() -> {
                if (fpss.findAndConnectToServer()) {
                    fpss.login();
                    return true;
                }
                return false;
            });
            try {
                if (future.get(30L, TimeUnit.SECONDS).booleanValue()) {
                    exec.shutdown();
                    return;
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            try {
                Thread.sleep(Config.getInt("RECONNECT_WAIT"));
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Interrupt", (Throwable)e);
                continue;
            }
            break;
        }
    }

    static {
        DISABLE_IP_LIM = false;
    }
}

