/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.thetadata.enums.SecType;
import net.thetadata.terminal.dev.OptionEntry;
import net.thetadata.terminal.dev.StockEntry;

public class Contract {
    private final boolean fastHash;
    public int exp;
    public int strike;
    private int hash;
    public SecType sec;
    public String root;
    public boolean isCall;

    public Contract(boolean fastHash) {
        this.fastHash = fastHash;
    }

    public Contract() {
        this(false);
    }

    public Contract read(String root, int exp, int strike, boolean isCall) {
        this.sec = SecType.OPTION;
        this.root = root;
        this.exp = exp;
        this.strike = strike;
        this.isCall = isCall;
        this.computeHashes();
        return this;
    }

    public SecType secType() {
        return this.sec;
    }

    public Contract read(String root) {
        return this.read(root, SecType.STOCK);
    }

    public Contract read(String root, SecType secType) {
        this.sec = secType;
        this.root = root;
        this.computeHashes();
        return this;
    }

    public Contract read(OptionEntry o) {
        this.sec = SecType.OPTION;
        this.root = new String(Arrays.copyOf(o.getRoot().getBytes(), o.getRoot().getBytes().length));
        this.exp = o.getExp();
        this.strike = o.getStrike();
        this.isCall = o.getRight() == 'C';
        this.computeHashes();
        return this;
    }

    public Contract read(StockEntry e) {
        this.sec = SecType.STOCK;
        this.root = new String(Arrays.copyOf(e.getRoot().getBytes(), e.getRoot().getBytes().length));
        this.computeHashes();
        return this;
    }

    public Contract read(Contract contract) {
        this.sec = contract.sec;
        this.root = new String(Arrays.copyOf(contract.root.getBytes(), contract.root.getBytes().length));
        if (this.sec == SecType.OPTION) {
            this.strike = contract.strike;
            this.exp = contract.exp;
            this.isCall = contract.isCall;
        }
        this.computeHashes();
        return this;
    }

    public String toString() {
        if (this.sec != SecType.OPTION) {
            return String.valueOf((Object)this.sec) + "-" + this.root;
        }
        return String.valueOf((Object)this.sec) + "-" + this.root + "-" + this.exp + "-" + this.strike + "-" + (this.isCall ? (char)'C' : 'P');
    }

    public void computeHashes() {
        this.hash = this.fastHash && this.sec == SecType.OPTION ? this.exp + (this.strike >> 4) : this.root.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Contract)) {
            return false;
        }
        Contract c = (Contract)o;
        if (this.sec == SecType.OPTION) {
            return c.sec == SecType.OPTION && c.root.equals(this.root) && c.isCall == this.isCall && c.strike == this.strike && c.exp == this.exp;
        }
        return this.root.equals(c.root);
    }

    public int hashCode() {
        return this.hash;
    }

    public int getStrike() {
        return this.strike;
    }

    public int getExp() {
        return this.exp;
    }

    public String getRoot() {
        return this.root;
    }

    public boolean isCall() {
        return this.isCall;
    }

    public boolean isOption() {
        return this.sec == SecType.OPTION;
    }

    public byte[] toBytes() {
        ByteBuffer out = ByteBuffer.allocate(this.sec != SecType.OPTION ? 3 + this.root.length() : 12 + this.root.length());
        if (this.root.length() > 16) {
            throw new IllegalStateException("Unexpected root size of: " + this.root.length());
        }
        out.put((byte)(this.sec != SecType.OPTION ? 3 + this.root.length() : 12 + this.root.length()));
        out.put((byte)this.root.length());
        out.put(this.root.getBytes(StandardCharsets.US_ASCII));
        out.put((byte)this.sec.code());
        if (this.sec == SecType.OPTION) {
            out.putInt(this.exp);
            out.put((byte)(this.isCall ? 1 : 0));
            out.putInt(this.strike);
        }
        return out.array();
    }

    public Contract fromBytes(byte[] data, int offset, int len) {
        ByteBuffer in = ByteBuffer.wrap(data, offset, len);
        byte size = in.get();
        if (len != size) {
            throw new IllegalStateException("Unexpected size of: " + len + " expected: " + size);
        }
        byte[] t2 = new byte[in.get()];
        in.get(t2);
        this.root = new String(t2);
        this.sec = SecType.of(in.get());
        if (this.sec == SecType.OPTION) {
            this.exp = in.getInt();
            this.isCall = in.get() == 1;
            this.strike = in.getInt();
        }
        this.computeHashes();
        return this;
    }

    public String toNiceString() {
        if (this.sec != SecType.OPTION) {
            return "E-" + this.root;
        }
        return "O-" + this.root + "-" + this.exp + "-" + this.strike + "-" + (this.isCall ? (char)'C' : 'P');
    }
}

