/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.client;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.thetadata.Tick;
import net.thetadata.enums.ReqArg;
import net.thetadata.enums.ReqType;
import net.thetadata.enums.StreamMsgType;
import net.thetadata.terminal.App;
import net.thetadata.terminal.Contract;
import net.thetadata.terminal.api.types.MessageType;
import net.thetadata.terminal.types.DataRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientStreamServer {
    private static final Logger logger = LogManager.getLogger(ClientStreamServer.class);
    private static ServerSocket server;
    private static Socket api;
    private static DataOutputStream out;
    private static BufferedReader in;
    private static final Contract DUMMY_CONTRACT;
    private static final Tick DUMMY_TICK;
    private static final Object writeLock;
    private static volatile String lastIP;
    private static Timer pinger;

    public static void init(int port) throws IOException {
        server = new ServerSocket();
        boolean attemptSuccessful = false;
        try {
            logger.debug("Attempting to start ClientStreamServer on port {}", (Object)port);
            server.bind(new InetSocketAddress("0.0.0.0", port));
        }
        catch (BindException e) {
            try {
                for (int i = 0; i < 50; ++i) {
                    try {
                        Thread.sleep(100L);
                        server = new ServerSocket();
                        server.bind(new InetSocketAddress("0.0.0.0", port));
                        attemptSuccessful = true;
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!attemptSuccessful) {
                    throw new ConnectException("");
                }
            }
            catch (Exception x) {
                logger.error("An instance of the Theta Terminal is already running or the port " + port + " is in use or this terminal was unable to terminate the old one. Please terminate any existing instances of the Theta Terminal or python scripts.", (Throwable)e);
                System.exit(1);
            }
        }
        server.setReceiveBufferSize(0x400000);
        new Thread(ClientStreamServer::handleConnections).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMsg(StreamMsgType type, Contract con, Tick t2) {
        Object object = writeLock;
        synchronized (object) {
            if (api == null) {
                return;
            }
            try {
                int[] toWrite;
                out.write(type.code());
                byte[] conBytes = con.toBytes();
                out.write(conBytes.length);
                out.write(conBytes);
                for (int i : toWrite = t2.data()) {
                    out.writeInt(i);
                }
                if (type == StreamMsgType.PING) {
                    out.flush();
                }
            }
            catch (IOException e) {
                logger.debug("IOException while sending message", (Throwable)e);
                pinger.cancel();
                api = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMsg(StreamMsgType type, byte[] data, int offset, int length) {
        Object object = writeLock;
        synchronized (object) {
            if (api == null) {
                return;
            }
            try {
                out.write(type.code());
                byte[] conBytes = DUMMY_CONTRACT.toBytes();
                out.write(conBytes.length);
                out.write(conBytes);
                out.write(data, offset, length);
                if (type == StreamMsgType.PING) {
                    out.flush();
                }
            }
            catch (IOException e) {
                logger.debug("IOException while sending message", (Throwable)e);
                pinger.cancel();
                api = null;
            }
        }
    }

    public static void handleMessages() {
        try {
            while (api != null) {
                DataRequest d;
                String s2 = in.readLine();
                if (s2 == null) {
                    return;
                }
                try {
                    d = new DataRequest(s2, true);
                }
                catch (Exception e) {
                    logger.error("Error parsing request: {}", (Object)s2);
                    logger.debug(e);
                    continue;
                }
                if (d.hasArg(ReqArg.VERSION)) continue;
                if (d.getMsgType() == MessageType.KILL) {
                    ExecutorService exec = Executors.newFixedThreadPool(1);
                    exec.submit(() -> logger.error("Shutting down..."));
                    try {
                        exec.awaitTermination(1L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        logger.error("error", (Throwable)e);
                    }
                    System.exit(0);
                    continue;
                }
                if (!api.isConnected()) {
                    logger.info("Disconnected from Theta Data.");
                    continue;
                }
                if (d.getMsgType() != MessageType.STREAM_REQ && d.getMsgType() != MessageType.STREAM_REMOVE) {
                    logger.error("Stream server requests must use MessageType.STREAM_REQ");
                    continue;
                }
                if (d.getStr(ReqArg.ROOT) == null && ReqType.from(d.getInt(ReqArg.REQ)) == ReqType.TRADE) {
                    App.getStreamClient().requestFullTrade(d.getSecType(), (int)d.getId(), d.getMsgType() == MessageType.STREAM_REMOVE);
                    continue;
                }
                if (d.getStr(ReqArg.ROOT) == null && ReqType.from(d.getInt(ReqArg.REQ)) == ReqType.OPEN_INTEREST) {
                    App.getStreamClient().requestFullOpenInt((int)d.getId(), d.getMsgType() == MessageType.STREAM_REMOVE);
                    continue;
                }
                String err = d.buildContract();
                if (err != null) {
                    logger.error(err);
                    continue;
                }
                if (d.getType() == ReqType.QUOTE) {
                    App.getStreamClient().requestQuote(d.getContract(), (int)d.getId(), d.getMsgType() == MessageType.STREAM_REMOVE);
                    continue;
                }
                if (d.getType() != ReqType.TRADE) continue;
                App.getStreamClient().requestTrade(d.getContract(), (int)d.getId(), d.getMsgType() == MessageType.STREAM_REMOVE);
            }
        }
        catch (IOException e) {
            if (!(e instanceof SocketException)) {
                logger.error("error", (Throwable)e);
            }
            logger.debug("SocketException", (Throwable)e);
        }
    }

    private static void handleConnections() {
        while (App.getStreamClient() == null || !App.getStreamClient().isConnected()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error("Handle Connections Interrupted", (Throwable)e);
            }
        }
        try {
            while (true) {
                Socket s2;
                if (!ClientStreamServer.singleIPCheck(s2 = server.accept())) {
                    continue;
                }
                s2.setTcpNoDelay(false);
                in = new BufferedReader(new InputStreamReader(s2.getInputStream()));
                out = new DataOutputStream(s2.getOutputStream());
                api = s2;
                ClientStreamServer.startPinging();
                ClientStreamServer.handleMessages();
            }
        }
        catch (IOException e) {
            logger.debug("IOException handling connections", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void sendMsg(StreamMsgType type) {
        ClientStreamServer.sendMsg(type, DUMMY_CONTRACT, DUMMY_TICK);
    }

    private static void startPinging() {
        pinger = new Timer();
        pinger.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    ClientStreamServer.sendMsg(StreamMsgType.PING, DUMMY_CONTRACT, DUMMY_TICK);
                }
                catch (Exception e) {
                    logger.error("Error while pinging", (Throwable)e);
                    pinger.cancel();
                }
            }
        }, 1000L, 1000L);
    }

    private static boolean singleIPCheck(Socket s2) throws IOException {
        if (lastIP == null) {
            lastIP = s2.getInetAddress().getHostName();
            return true;
        }
        if (App.DISABLE_IP_LIM) {
            return true;
        }
        if (!lastIP.equals(s2.getInetAddress().getHostName())) {
            s2.close();
            logger.warn("Closing HTTP connection because the IP {} differs from the accept IP of {}", (Object)s2.getInetAddress().getHostName(), (Object)lastIP);
            return false;
        }
        return true;
    }

    static {
        DUMMY_CONTRACT = new Contract(true).read("DUMMY");
        DUMMY_TICK = new Tick(1);
        writeLock = new Object();
    }
}

