/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.dev;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.thetadata.Timer;
import net.thetadata.terminal.Contract;

public class SampleDataGenerator {
    public static List<Contract> generateContracts0DTE(List<String> syms, int date) throws IOException {
        URL contracts = new URL("http://127.0.0.1:25510/v2/list/contracts/option/quote?use_csv=true&start_date=" + date);
        try {
            String contract;
            BufferedReader br = new BufferedReader(new InputStreamReader(contracts.openStream()));
            ArrayList<Contract> out = new ArrayList<Contract>();
            br.readLine();
            while ((contract = br.readLine()) != null) {
                String[] args = contract.split(",");
                if (!syms.contains(args[0]) || Integer.parseInt(args[1]) != date) continue;
                out.add(new Contract().read(args[0], Integer.parseInt(args[1]), Integer.parseInt(args[2]), args[3].charAt(0) == 'C'));
            }
            out.sort(Comparator.comparingInt(Contract::getStrike));
            return out;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static List<String> generateQuoteURLs(List<Contract> contracts, int date) {
        if (contracts == null) {
            return List.of();
        }
        ArrayList<String> out = new ArrayList<String>();
        for (Contract con : contracts) {
            out.add("http://127.0.0.1:25510/hist/option/quote?root=" + con.root + "&start_date=" + date + "&end_date=" + date + "&strike=" + con.getStrike() + "&exp=" + con.getExp() + "&right=" + (con.isCall() ? (char)'C' : 'P') + "&use_csv=true");
        }
        return out;
    }

    public static List<String> listURLsPerDateQuote(List<String> syms, int date) throws IOException {
        return SampleDataGenerator.generateQuoteURLs(SampleDataGenerator.generateContracts0DTE(syms, date), date);
    }

    public static void generateQuotes() throws IOException {
        Timer.start();
        List<String> syms = List.of("SPX", "SPXW", "NDX", "NDXP", "SPXQ", "SPXM");
        File dir = new File("C:\\Users\\baile\\OneDrive\\Quantbot2\\0dte_index_options\\quotes");
        dir.mkdirs();
        for (int i = 20220101; i < 20220602; ++i) {
            List<String> urls = SampleDataGenerator.listURLsPerDateQuote(syms, i);
            System.out.println("date completed: " + i + " elapsed " + Timer.stop() / 1000L);
            if (urls == null || urls.isEmpty()) continue;
            File f = new File(dir, i + ".txt");
            f.createNewFile();
            PrintWriter p = new PrintWriter(new FileWriter(f));
            for (String s2 : urls) {
                p.println(s2);
            }
            p.close();
        }
    }

    public static void main(String[] args) throws IOException {
        SampleDataGenerator.generateQuotes();
    }
}

