/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.net;

import net.thetadata.Tick;
import net.thetadata.terminal.api.utils.PriceCalc;

public class OHLCVC {
    private int time;
    private final int open;
    private int high;
    private int low;
    private int close;
    private int volume;
    private int count;
    private final int priceType;
    private final int date;
    private final Tick tick;

    public OHLCVC(int[] data) {
        this.time = data[1];
        this.open = data[2];
        this.high = data[3];
        this.low = data[4];
        this.close = data[5];
        this.volume = data[6];
        this.count = data[7];
        this.priceType = data[8];
        this.date = data[9];
        this.tick = new Tick(9);
    }

    public void processTrade(int[] data) {
        this.time = data[0];
        int newPrice = PriceCalc.changePriceType(data[4], data[6], this.priceType);
        this.volume += data[2];
        ++this.count;
        if (newPrice > this.high) {
            this.high = newPrice;
        }
        if (newPrice < this.low) {
            this.low = newPrice;
        }
        this.close = newPrice;
    }

    public Tick tick() {
        int[] data = this.tick.data();
        data[0] = this.time;
        data[1] = this.open;
        data[2] = this.high;
        data[3] = this.low;
        data[4] = this.close;
        data[5] = this.volume;
        data[6] = this.count;
        data[7] = this.priceType;
        data[8] = this.date;
        return this.tick;
    }
}

