/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.net;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.thetadata.Tick;
import net.thetadata.enums.RemoveReason;
import net.thetadata.enums.SecType;
import net.thetadata.enums.StreamMsgType;
import net.thetadata.enums.StreamResponseType;
import net.thetadata.terminal.App;
import net.thetadata.terminal.Contract;
import net.thetadata.terminal.cfg.Config;
import net.thetadata.terminal.client.ClientStreamServer;
import net.thetadata.terminal.http.FullTradeWS;
import net.thetadata.terminal.net.FITReader;
import net.thetadata.terminal.net.OHLCVC;
import net.thetadata.terminal.net.PacketStream2;
import net.thetadata.terminal.net.StreamPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FPSSClient
implements EventHandler<StreamPacket> {
    private static final Logger logger = LogManager.getLogger(FPSSClient.class);
    private static final int REPORT_WARNING_EVERY = 10000;
    private String host;
    private String pass;
    private final List<String> hosts;
    private static final byte[] PING = new byte[1];
    private String user;
    private RemoveReason last;
    private volatile String perms;
    private final AtomicBoolean isConnected = new AtomicBoolean();
    private final AtomicBoolean foundServer = new AtomicBoolean();
    private SSLSocket client;
    private volatile PacketStream2 io;
    private final HashMap<Integer, Tick> lastQuotes = new HashMap();
    private final HashMap<Integer, Tick> lastTrades = new HashMap();
    private final HashMap<Integer, OHLCVC> lastOHLCVC = new HashMap();
    private final HashMap<Integer, Contract> idToContract = new HashMap();
    private Disruptor<StreamPacket> dr;
    private RingBuffer<StreamPacket> rb;
    private static final ConcurrentHashMap<Integer, Contract> tradeReqs = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, Contract> quoteReqs = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Contract, Contract> activeTrades = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Contract, Contract> activeQuotes = new ConcurrentHashMap();
    private final ExecutorService exec = Executors.newFixedThreadPool(2);
    private static final AtomicBoolean useFullTrades = new AtomicBoolean();
    private static final AtomicBoolean useFullTradesWSOpt = new AtomicBoolean();
    private static final AtomicBoolean useFullTradesWSStk = new AtomicBoolean();
    private static final AtomicBoolean useFullOpenInterest = new AtomicBoolean();
    private Timer pinger;
    private final FITReader fitReader = new FITReader();
    private final int[] alloc = new int[32];
    private final boolean isToken;
    private static final AtomicBoolean madeConnect = new AtomicBoolean();
    private volatile long lastStop = 0L;

    public FPSSClient(String ... hostnames) throws IOException {
        FPSSClient.createTrust();
        this.hosts = Arrays.asList(hostnames);
        if (!this.findAndConnectToServer()) {
            logger.error("[FPSS] Unable to connect to any listed streaming servers. Please ensure you are not trying to use the test server and there is no scheduled maintenance. Theta Terminal will attempt to connect to an available server every " + Config.getInt("RECONNECT_WAIT") + "ms...");
            while (!this.findAndConnectToServer()) {
                try {
                    Thread.sleep(Config.getInt("RECONNECT_WAIT"));
                }
                catch (Exception e) {
                    logger.debug("interrupt", (Throwable)e);
                }
            }
        }
        this.foundServer.set(true);
        this.isToken = false;
    }

    public FPSSClient(FPSSClient old, String ... hostnames) {
        this.hosts = Arrays.asList(hostnames);
        this.user = old.user;
        this.pass = old.pass;
        this.isToken = true;
    }

    public boolean findAndConnectToServer() {
        for (String s2 : this.hosts) {
            try {
                String[] t2 = s2.split(":");
                this.connect(t2[0], Integer.parseInt(t2[1]));
                this.startMessageProcessing();
                this.host = s2;
                return true;
            }
            catch (IOException e) {
                if (!(e instanceof SocketException) || !(e.getCause() instanceof NoSuchAlgorithmException)) continue;
                logger.error("Java does not recognize encryption the algorithm. Please try using a newer version of java.", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Unable to connect to: " + s2 + "because of the exception below. Attempting to connect to another server...", (Throwable)e);
            }
        }
        return false;
    }

    private void connect(String hostname, int port) throws IOException {
        logger.debug("Attempting to connect to {}:{}", (Object)hostname, (Object)port);
        this.client = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
        this.client.setTcpNoDelay(true);
        this.client.setSoTimeout(10000);
        this.client.connect(new InetSocketAddress(hostname, port), 2000);
        this.client.startHandshake();
        this.io = new PacketStream2(this.client.getInputStream(), this.client.getOutputStream());
    }

    public void login(String user, String pass) {
        this.user = user;
        this.pass = pass;
        logger.info("[FPSS] Attempting login as {}", (Object)user);
        ByteBuffer out = ByteBuffer.allocate(3 + user.getBytes().length + pass.getBytes().length);
        out.put((byte)0);
        out.putShort((byte)user.getBytes().length);
        out.put(user.getBytes());
        out.put(pass.getBytes());
        this.sendMsg(StreamMsgType.CREDENTIALS, out.array());
    }

    public void login() {
        logger.info("[FPSS] Attempting login as {}", (Object)this.user);
        ByteBuffer out = ByteBuffer.allocate(3 + this.user.getBytes().length + this.pass.getBytes().length);
        out.put((byte)0);
        out.putShort((byte)this.user.getBytes().length);
        out.put(this.user.getBytes());
        out.put(this.pass.getBytes());
        this.sendMsg(StreamMsgType.CREDENTIALS, out.array());
    }

    public boolean sendPing() {
        try {
            this.io.write(StreamMsgType.PING, PING, 1);
        }
        catch (IOException e) {
            logger.debug("Error sending ping", (Throwable)e);
            this.close();
            return false;
        }
        return true;
    }

    public void sendMsg(StreamMsgType msg, byte[] data) {
        block2: {
            logger.debug("Sending message: {}", (Object)msg);
            try {
                this.io.write(msg, data, data.length);
            }
            catch (IOException e) {
                logger.debug("Error sending message", (Throwable)e);
                if (msg == StreamMsgType.DISCONNECTED) break block2;
                this.close();
            }
        }
    }

    public void requestQuote(Contract con, int id, boolean isRemove) {
        if (isRemove) {
            quoteReqs.remove(id);
            activeQuotes.remove(con);
        } else {
            quoteReqs.put(id, con);
        }
        byte[] conBytes = con.toBytes();
        ByteBuffer b = ByteBuffer.allocate(4 + conBytes.length);
        b.putInt(id);
        b.put(conBytes);
        this.sendMsg(isRemove ? StreamMsgType.REMOVE_QUOTE : StreamMsgType.QUOTE, b.array());
    }

    public void requestTrade(Contract con, int id, boolean isRemove) {
        if (isRemove) {
            tradeReqs.remove(id);
            activeTrades.remove(con);
        } else {
            tradeReqs.put(id, con);
        }
        byte[] conBytes = con.toBytes();
        ByteBuffer b = ByteBuffer.allocate(4 + conBytes.length);
        b.putInt(id);
        b.put(conBytes);
        this.sendMsg(isRemove ? StreamMsgType.REMOVE_TRADE : StreamMsgType.TRADE, b.array());
    }

    public void requestFullTrade(SecType sec, int id, boolean isRemove) {
        ByteBuffer b = ByteBuffer.allocate(5);
        b.putInt(id);
        b.put((byte)sec.code());
        this.sendMsg(isRemove ? StreamMsgType.REMOVE_TRADE : StreamMsgType.TRADE, b.array());
        useFullTrades.set(true);
    }

    public void requestFullTradeWS(SecType sec, int id, boolean isRemove, FullTradeWS handle) {
        ByteBuffer b = ByteBuffer.allocate(5);
        b.putInt(id);
        b.put((byte)(sec == SecType.OPTION ? 1 : 0));
        this.sendMsg(isRemove ? StreamMsgType.REMOVE_TRADE : StreamMsgType.TRADE, b.array());
        if (sec == SecType.OPTION) {
            useFullTradesWSOpt.set(true);
        } else if (sec == SecType.STOCK) {
            useFullTradesWSStk.set(true);
        }
    }

    public void requestFullTradeWS(SecType sec, int id, boolean isRemove) {
        ByteBuffer b = ByteBuffer.allocate(5);
        b.putInt(id);
        b.put((byte)sec.code());
        this.sendMsg(isRemove ? StreamMsgType.REMOVE_TRADE : StreamMsgType.TRADE, b.array());
        if (sec == SecType.OPTION) {
            useFullTradesWSOpt.set(true);
        } else if (sec == SecType.STOCK) {
            useFullTradesWSStk.set(true);
        }
    }

    public void requestFullOpenInt(int id, boolean isRemove) {
        ByteBuffer b = ByteBuffer.allocate(5);
        b.putInt(id);
        b.put((byte)1);
        this.sendMsg(isRemove ? StreamMsgType.REMOVE_OPEN_INTEREST : StreamMsgType.OPEN_INTEREST, b.array());
        useFullOpenInterest.set(true);
    }

    public void close() {
        try {
            logger.debug("Closing");
            this.client.close();
        }
        catch (Exception e) {
            logger.error("Error closing client", (Throwable)e);
        }
    }

    private void startMessageProcessing() {
        int queueDepth = Config.getInt("FPSS_QUEUE_DEPTH");
        int actualQueueSize = 1 << (queueDepth == 0 ? 0 : 32 - Integer.numberOfLeadingZeros(queueDepth - 1));
        logger.debug("QueueDepth: {}; actualQueueSize: {}", (Object)queueDepth, (Object)actualQueueSize);
        this.dr = new Disruptor<StreamPacket>(() -> new StreamPacket(0, new byte[256], -1), actualQueueSize, DaemonThreadFactory.INSTANCE, ProducerType.SINGLE, new BlockingWaitStrategy());
        this.dr.handleEventsWith(this);
        this.rb = this.dr.start();
        this.exec.submit(() -> {
            int reportCount = 10000;
            try {
                while (true) {
                    if ((double)this.rb.remainingCapacity() / (double)actualQueueSize < 0.1 && ++reportCount > 10000) {
                        logger.warn("FPSS_QUEUE is >90% full, will start dropping messages soon");
                        reportCount = 0;
                    }
                    long id = this.rb.next();
                    this.io.readCopy(this.rb.get(id));
                    this.rb.publish(id);
                }
            }
            catch (IOException e) {
                logger.debug("Involuntary disconnect: ", (Throwable)e);
                this.close();
                this.handleInvoluntaryDisconnect();
                return;
            }
            catch (Exception e) {
                logger.error("An unexpected error has occurred. Attempting to reconnect to Theta Data...", (Throwable)e);
                this.close();
                this.handleInvoluntaryDisconnect();
                return;
            }
        });
    }

    @Override
    public void onEvent(StreamPacket event, long sequence, boolean endOfBatch) throws Exception {
        try {
            this.processMessage(event);
        }
        catch (Exception e) {
            logger.error("An unexpected error has occurred. Attempting to reconnect to Theta Data...", (Throwable)e);
            this.close();
        }
    }

    private void processMessage(StreamPacket p) throws Exception {
        if (p == null || p.msg() == null) {
            logger.error("Null packet msg");
            return;
        }
        switch (p.msg()) {
            case QUOTE: {
                this.processQuote(p);
                return;
            }
            case TRADE: {
                this.processTrade(p);
                return;
            }
            case CONTRACT: {
                this.processContract(p);
                return;
            }
            case OPEN_INTEREST: {
                this.processOpenInt(p);
                return;
            }
            case OHLCVC: {
                this.processOHLCVC(p);
                return;
            }
            case START: {
                this.lastQuotes.clear();
                this.lastTrades.clear();
                this.lastOHLCVC.clear();
                this.idToContract.clear();
                ClientStreamServer.sendMsg(p.msg(), p.data(), 0, p.len());
                if (App.getWsEvents() != null) {
                    App.getWsEvents().state("START");
                }
                return;
            }
            case STOP: {
                this.lastQuotes.clear();
                this.lastTrades.clear();
                this.lastOHLCVC.clear();
                this.idToContract.clear();
                ClientStreamServer.sendMsg(p.msg(), p.data(), 0, p.len());
                if (App.getWsEvents() != null) {
                    App.getWsEvents().state("STOP");
                }
                return;
            }
            case PING: {
                return;
            }
            case REQ_RESPONSE: {
                ClientStreamServer.sendMsg(StreamMsgType.REQ_RESPONSE, p.data(), 0, p.len());
                ByteBuffer bb = ByteBuffer.wrap(p.data());
                int reqId = bb.getInt();
                StreamResponseType response = StreamResponseType.from((short)bb.getInt());
                if (App.getWsEvents() != null) {
                    App.getWsEvents().reqResponse(reqId, response);
                }
                if (response != StreamResponseType.SUBSCRIBED) {
                    return;
                }
                if (quoteReqs.containsKey(reqId)) {
                    activeQuotes.put(quoteReqs.get(reqId), quoteReqs.get(reqId));
                    quoteReqs.remove(reqId);
                    return;
                }
                if (tradeReqs.containsKey(reqId)) {
                    activeTrades.put(tradeReqs.get(reqId), tradeReqs.get(reqId));
                    tradeReqs.remove(reqId);
                    return;
                }
                return;
            }
            case ERROR: {
                logger.warn("FPSS ERROR: {}", (Object)new String(p.data()));
                return;
            }
            case RECONNECTED: {
                logger.debug("Got RECONNECTED message");
                ClientStreamServer.sendMsg(StreamMsgType.RECONNECTED);
                return;
            }
            case SESSION_TOKEN: {
                logger.debug("Got SESSION_TOKEN message");
                return;
            }
            case METADATA: {
                try {
                    this.perms = new String(p.data(), 0, p.len());
                    logger.info("[FPSS] CONNECTED: [{}], Bundle: {}", (Object)this.host, (Object)this.perms);
                    this.startPinging();
                    if (this.isToken) {
                        ClientStreamServer.sendMsg(StreamMsgType.RECONNECTED);
                    }
                    if (useFullTrades.get()) {
                        this.requestFullTrade(SecType.OPTION, -1, false);
                    }
                    if (useFullOpenInterest.get()) {
                        this.requestFullOpenInt(-1, false);
                    }
                    if (useFullTradesWSOpt.get()) {
                        this.requestFullTradeWS(SecType.OPTION, -1, false);
                    }
                    if (useFullTradesWSStk.get()) {
                        this.requestFullTradeWS(SecType.STOCK, -1, false);
                    }
                    tradeReqs.clear();
                    quoteReqs.clear();
                    for (Contract c : activeQuotes.keySet()) {
                        this.requestQuote(c, -1, false);
                    }
                    for (Contract c : activeTrades.keySet()) {
                        this.requestTrade(c, -1, false);
                    }
                    madeConnect.set(true);
                    this.isConnected.set(true);
                }
                catch (Exception e) {
                    logger.debug("Error processing METADATA message", (Throwable)e);
                }
                return;
            }
            case DISCONNECTED: {
                this.last = RemoveReason.from(ByteBuffer.wrap(p.data()).getShort());
                logger.warn("[FPSS] Disconnected from server: {}", (Object)this.last);
                if (!(madeConnect.get() || this.last != RemoveReason.INVALID_CREDENTIALS && this.last != RemoveReason.GENERAL_VALIDATION_ERROR)) {
                    logger.warn("Your password might contain invalid characters. Try resetting it: https://thetadata.net > sign out > log in > forgot password.");
                }
                this.host = null;
            }
        }
    }

    private void processTrade(StreamPacket p) {
        this.fitReader.open(p.data(), p.len());
        int size = this.fitReader.readChanges(this.alloc);
        Contract c = this.idToContract.get(this.alloc[0]);
        if (c == null) {
            if (System.currentTimeMillis() - this.lastStop > 5000L) {
                logger.error("No trade contract for ID: {}", (Object)this.alloc[0]);
            }
            return;
        }
        Tick last = this.lastTrades.get(this.alloc[0]);
        if (last == null) {
            this.lastTrades.put(this.alloc[0], new Tick(size - 1).readID(this.alloc));
            if (App.getWsEvents() != null) {
                App.getWsEvents().handleTrade(c, this.lastTrades.get(this.alloc[0]));
            }
            ClientStreamServer.sendMsg(StreamMsgType.TRADE, c, this.lastTrades.get(this.alloc[0]));
            return;
        }
        last.readID(this.alloc, size);
        OHLCVC lastO = this.lastOHLCVC.get(this.alloc[0]);
        if (lastO != null) {
            lastO.processTrade(last.data());
            if (App.getWsEvents() != null) {
                App.getWsEvents().readOHLC(c, this.lastOHLCVC.get(this.alloc[0]).tick(), true);
            }
            ClientStreamServer.sendMsg(StreamMsgType.OHLCVC, c, this.lastOHLCVC.get(this.alloc[0]).tick());
        } else {
            logger.error("Unexpected null OHLCVC: {}", (Object)c);
        }
        if (App.getWsEvents() != null) {
            App.getWsEvents().handleTrade(c, last);
        }
        ClientStreamServer.sendMsg(StreamMsgType.TRADE, c, last);
    }

    private void processOHLCVC(StreamPacket p) throws IOException {
        this.fitReader.open(p.data(), p.len());
        this.fitReader.readChanges(this.alloc);
        Contract c = this.idToContract.get(this.alloc[0]);
        if (c == null) {
            if (System.currentTimeMillis() - this.lastStop > 5000L) {
                logger.error("No OHLC contract for ID: {}", (Object)this.alloc[0]);
            }
            return;
        }
        OHLCVC last = this.lastOHLCVC.get(this.alloc[0]);
        if (last == null) {
            this.lastOHLCVC.put(this.alloc[0], new OHLCVC(this.alloc));
            ClientStreamServer.sendMsg(StreamMsgType.OHLCVC, c, this.lastOHLCVC.get(this.alloc[0]).tick());
            if (App.getWsEvents() != null) {
                App.getWsEvents().readOHLC(c, this.lastOHLCVC.get(this.alloc[0]).tick(), true);
            }
        } else {
            logger.error("Unexpected OHLCVC Message: {} con ID: {}", (Object)c, (Object)this.alloc[0]);
        }
    }

    private void processQuote(StreamPacket p) {
        this.fitReader.open(p.data(), p.len());
        int size = this.fitReader.readChanges(this.alloc);
        Contract c = this.idToContract.get(this.alloc[0]);
        if (c == null) {
            if (System.currentTimeMillis() - this.lastStop > 5000L) {
                logger.error("No quote contract for ID: {}", (Object)this.alloc[0]);
            }
            return;
        }
        Tick last = this.lastQuotes.get(this.alloc[0]);
        if (last == null) {
            this.lastQuotes.put(this.alloc[0], new Tick(size - 1).readID(this.alloc));
            if (App.getWsEvents() != null) {
                App.getWsEvents().readQuote(c, this.lastQuotes.get(this.alloc[0]));
            }
            ClientStreamServer.sendMsg(StreamMsgType.QUOTE, c, this.lastQuotes.get(this.alloc[0]));
            return;
        }
        last.readID(this.alloc, size);
        if (App.getWsEvents() != null) {
            App.getWsEvents().readQuote(c, last);
        }
        ClientStreamServer.sendMsg(StreamMsgType.QUOTE, c, last);
    }

    private void processContract(StreamPacket p) {
        Contract con = new Contract(true).fromBytes(p.data(), 4, p.len() - 4);
        int id = ByteBuffer.wrap(p.data()).getInt();
        this.idToContract.put(id, con);
    }

    private void processOpenInt(StreamPacket p) throws IOException {
        this.fitReader.open(p.data(), p.len());
        int size = this.fitReader.readChanges(this.alloc);
        Contract c = this.idToContract.get(this.alloc[0]);
        if (c == null) {
            if (System.currentTimeMillis() - this.lastStop > 5000L) {
                logger.error("No open interest contract for ID: " + this.alloc[0]);
            }
            return;
        }
        ClientStreamServer.sendMsg(StreamMsgType.OPEN_INTEREST, c, new Tick(size - 1).readID(this.alloc));
    }

    private void startPinging() {
        this.pinger = new Timer();
        this.pinger.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (FPSSClient.this.perms == null) {
                        FPSSClient.this.pinger.cancel();
                        return;
                    }
                    if (!FPSSClient.this.sendPing()) {
                        FPSSClient.this.pinger.cancel();
                    }
                }
                catch (Exception e) {
                    FPSSClient.this.pinger.cancel();
                }
            }
        }, 2000L, 100L);
    }

    private void handleInvoluntaryDisconnect() {
        logger.debug("Involuntary disconnect: {}", (Object)this.last);
        try {
            this.dr.halt();
        }
        catch (Exception e) {
            logger.debug("Error stopping disruptor", (Throwable)e);
        }
        if (this.last == RemoveReason.ACCOUNT_ALREADY_CONNECTED) {
            this.isConnected.set(false);
            return;
        }
        this.isConnected.set(false);
        ClientStreamServer.sendMsg(StreamMsgType.DISCONNECTED);
        final FPSSClient old = this;
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                App.handleInvoluntaryDisconnectFPSS(old);
            }
        }, this.last == RemoveReason.TOO_MANY_REQUESTS ? 130000L : 2000L);
        this.exec.shutdownNow();
    }

    private static void createTrust() throws IOException {
        File f = new File(App.ROOT_DIR, "client.jks");
        boolean exists = f.exists();
        f.createNewFile();
        Files.write(f.toPath(), App.class.getResourceAsStream("/client.jks").readAllBytes(), new OpenOption[0]);
        if (!exists) {
            try {
                Thread.sleep(250L);
            }
            catch (Exception e) {
                logger.debug("Error sleeping", (Throwable)e);
            }
        }
        System.setProperty("javax.net.ssl.trustStore", f.toString());
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
    }

    public boolean isVerified() {
        return this.perms != null;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isConnected() {
        return this.isConnected.get();
    }

    public boolean foundServer() {
        return this.foundServer.get();
    }

    public void requestStop() {
        this.sendMsg(StreamMsgType.STOP, PING);
        this.lastStop = System.currentTimeMillis();
    }
}

