/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.client;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.thetadata.enums.DataType;
import net.thetadata.enums.SecType;
import net.thetadata.terminal.Contract;
import net.thetadata.terminal.api.types.MessageType;
import net.thetadata.terminal.api.utils.PriceCalc;
import net.thetadata.terminal.net.FITReader;
import net.thetadata.terminal.types.ErrorMsg;

public class RestQueryMessage {
    private long id;
    private long latency;
    private String nextPage;
    private DataType[] format;
    private String errorType;
    private String errorMsg;
    private final StringBuilder sb = new StringBuilder(0x100000);
    private static final char[] newLineCSV = new char[]{'\r', '\n'};
    private static final char newLineJSON = '\n';
    private static final String padding = "\t\t[";
    private static final String paddingStr = "\t\t";
    private static final String paddingStr3 = "\t\t\t\t";
    private static final String startLine = "\t\"response\": [\n";
    private static final String lastLine = " \t]\n}";
    private static final String lastLine2 = " \t]\n}";

    public void readHeader(long id, long latency, MessageType msg, DataType[] format) {
        this.id = id;
        this.latency = latency;
        this.format = format;
        this.errorMsg = null;
        this.errorType = null;
    }

    public void readHeader2(long id, long latency, String nextPage, DataType[] format) {
        this.id = id;
        this.latency = latency;
        this.nextPage = nextPage;
        this.format = format;
    }

    public void readErrorHeader(long id, long latency, ErrorMsg msg, String info) {
        this.id = id;
        this.latency = latency;
        this.format = null;
        this.errorMsg = info.replace("\"", "");
        this.errorType = msg.toString().replace("\"", "");
    }

    public void toCSV(DataType[] headerFormat, DataType[] format, FITReader fr, int pTypeIndex) {
        this.sb.setLength(0);
        this.sb.append(Arrays.toString((Object[])headerFormat).replace("[", "").replace("]", "").replace(" ", "").toLowerCase());
        this.sb.append('\n');
        while (fr.readTick() != null) {
            int[] tick = fr.peek().data();
            for (int i = 0; i < tick.length; ++i) {
                if (i == pTypeIndex) continue;
                if (format[i].isPrice()) {
                    PriceCalc.fmtPrice(this.sb, PriceCalc.getPriceDouble(tick[i], tick[pTypeIndex]), 4);
                } else {
                    this.sb.append(tick[i]);
                }
                this.sb.append(',');
            }
            this.sb.setCharAt(this.sb.length() - 1, '\n');
        }
    }

    public void clear() {
        this.sb.setLength(0);
    }

    public boolean toCSV2(DataType[] headerFormat, DataType[] format, FITReader fr, int pTypeIndex, int tickLimit, boolean prettyTime) {
        this.sb.setLength(0);
        this.sb.append(Arrays.toString((Object[])headerFormat).replace("[", "").replace("]", "").replace(" ", "").toLowerCase());
        this.sb.append(newLineCSV);
        int ticksRead = 0;
        int[] timeIndices = new int[2];
        boolean isStringResponse = false;
        Arrays.fill(timeIndices, -1);
        for (int i = 0; i < format.length; ++i) {
            if (format[i].isStr()) {
                isStringResponse = true;
            }
            if (format[i] == DataType.MS_OF_DAY) {
                timeIndices[0] = i;
                continue;
            }
            if (format[i] != DataType.MS_OF_DAY2) continue;
            timeIndices[1] = i;
        }
        if (isStringResponse) {
            String[] ref;
            fr.isFirst(true);
            while ((ref = fr.readStringTick()) != null) {
                fr.isFirst(true);
                for (int i = 0; i < ref.length && ref[i] != null; ++i) {
                    if (prettyTime && format[i].isDate()) {
                        RestQueryMessage.addPrettyDate(Integer.parseInt(ref[i]), this.sb);
                    } else if (prettyTime && (i == timeIndices[0] || i == timeIndices[1])) {
                        RestQueryMessage.addPrettyTime(Integer.parseInt(ref[i]), this.sb);
                    } else if (format[i] == DataType.CONDITION) {
                        this.sb.append(Integer.parseInt(ref[i]) & 0xFF);
                    } else if (format[i] == DataType.SYMBOL && Character.isLowerCase(ref[i].charAt(0))) {
                        this.sb.append(ref[i].substring(1));
                    } else {
                        this.sb.append(format[i] == DataType.SYMBOL_CHANGE_TYPE ? ref[i].replace(" ", "") : ref[i]);
                    }
                    this.sb.append(',');
                }
                this.sb.setLength(this.sb.length() - 1);
                this.sb.append(newLineCSV);
                if (ticksRead++ < tickLimit || !fr.hasRemaining()) continue;
                return true;
            }
        } else {
            while (fr.readTick() != null) {
                int[] tick = fr.peek().data();
                for (int i = 0; i < tick.length; ++i) {
                    if (i == pTypeIndex) continue;
                    if (format[i].isPrice()) {
                        PriceCalc.fmtPrice(this.sb, PriceCalc.getPriceDouble(tick[i], tick[pTypeIndex]), 4);
                    } else if (prettyTime && format[i].isDate()) {
                        RestQueryMessage.addPrettyDate(tick[i], this.sb);
                    } else if (prettyTime && (i == timeIndices[0] || i == timeIndices[1])) {
                        RestQueryMessage.addPrettyTime(tick[i], this.sb);
                    } else if (format[i] == DataType.CONDITION) {
                        this.sb.append(tick[i] & 0xFF);
                    } else {
                        this.sb.append(tick[i]);
                    }
                    this.sb.append(',');
                }
                this.sb.setLength(this.sb.length() - 1);
                this.sb.append(newLineCSV);
                if (ticksRead++ < tickLimit || !fr.hasRemaining()) continue;
                return true;
            }
        }
        return false;
    }

    public static void addPrettyDate(int date, StringBuilder sb) {
        int year = date / 10000;
        int month = (date - year * 10000) / 100;
        int day = date % 100;
        sb.append(year);
        sb.append('-');
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month);
        sb.append('-');
        if (day < 10) {
            sb.append('0');
        }
        sb.append(day);
    }

    public static void addPrettyTime(int msOfDay, StringBuilder sb) {
        int hour = msOfDay / 3600000;
        int minute = (msOfDay - hour * 3600000) / 60000;
        int second = (msOfDay - hour * 3600000 - minute * 60000) / 1000;
        int ms = msOfDay % 1000;
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour);
        sb.append(':');
        if (minute < 10) {
            sb.append('0');
        }
        sb.append(minute);
        sb.append(':');
        if (second < 10) {
            sb.append('0');
        }
        sb.append(second);
        sb.append('.');
        if (ms < 100) {
            sb.append('0');
        }
        if (ms < 10) {
            sb.append('0');
        }
        sb.append(ms);
    }

    public boolean toCSVBulk(DataType[] headerFormat, DataType[] format, FITReader fr, int pTypeIndex, int tickLimit, SecType sec, ByteBuffer bb, boolean isLast, boolean prettyTime) {
        this.sb.setLength(0);
        this.sb.append(sec == SecType.OPTION ? "root,expiration,strike,right," : "root,");
        this.sb.append(Arrays.toString((Object[])headerFormat).replace("[", "").replace("]", "").replace(" ", "").toLowerCase());
        this.sb.append(newLineCSV);
        int ticksRead = 0;
        Contract con = new Contract();
        int[] timeIndices = new int[2];
        Arrays.fill(timeIndices, -1);
        for (int i = 0; i < format.length; ++i) {
            if (format[i] == DataType.MS_OF_DAY) {
                timeIndices[0] = i;
                continue;
            }
            if (format[i] != DataType.MS_OF_DAY2) continue;
            timeIndices[1] = i;
        }
        while (bb.hasRemaining()) {
            byte[] temp = new byte[bb.get()];
            bb.get(temp);
            con.fromBytes(temp, 0, temp.length);
            byte[] tickData = new byte[isLast ? bb.get() : bb.getInt()];
            bb.get(tickData);
            fr.open(tickData);
            while (fr.readTick() != null) {
                if (sec == SecType.OPTION) {
                    this.sb.append(con.root).append(',');
                    if (prettyTime) {
                        RestQueryMessage.addPrettyDate(con.getExp(), this.sb);
                    } else {
                        this.sb.append(con.getExp());
                    }
                    this.sb.append(',').append(con.getStrike()).append(',').append(con.isCall() ? "C" : "P").append(',');
                } else {
                    this.sb.append(con.root).append(',');
                }
                int[] tick = fr.peek().data();
                for (int i = 0; i < tick.length; ++i) {
                    if (i == pTypeIndex) continue;
                    if (format[i].isPrice()) {
                        PriceCalc.fmtPrice(this.sb, PriceCalc.getPriceDouble(tick[i], tick[pTypeIndex]), PriceCalc.PLACES[tick[pTypeIndex]]);
                    } else if (prettyTime && (format[i] == DataType.DATE || format[i] == DataType.EX_DATE || format[i] == DataType.ANN_DATE || format[i] == DataType.PAYMENT_DATE || format[i] == DataType.RECORD_DATE || format[i] == DataType.SPLIT_DATE)) {
                        RestQueryMessage.addPrettyDate(tick[i], this.sb);
                    } else if (prettyTime && (i == timeIndices[0] || i == timeIndices[1])) {
                        RestQueryMessage.addPrettyTime(tick[i], this.sb);
                    } else {
                        this.sb.append(tick[i]);
                    }
                    this.sb.append(',');
                }
                this.sb.setLength(this.sb.length() - 1);
                this.sb.append(newLineCSV);
                ++ticksRead;
            }
            if (ticksRead < tickLimit || !bb.hasRemaining()) continue;
            return true;
        }
        return false;
    }

    public void toCSVContracts(byte[] contracts, SecType sec) {
        this.sb.setLength(0);
        this.sb.append(sec == SecType.OPTION ? "root,expiration,strike,right" : "root");
        this.sb.append(newLineCSV);
        Contract con = new Contract();
        for (int pos = 0; pos < contracts.length; pos += contracts[pos]) {
            con.fromBytes(contracts, pos, contracts[pos]);
            if (sec == SecType.OPTION) {
                this.sb.append(con.root).append(',').append(con.getExp()).append(',').append(con.getStrike()).append(',').append(con.isCall() ? "C" : "P").append(newLineCSV);
                continue;
            }
            this.sb.append(con.root).append(newLineCSV);
        }
    }

    public void toCSVList(String[] format, String[] contracts) {
        this.sb.setLength(0);
        for (String s2 : format) {
            this.sb.append(s2.replace("\"", "")).append(',');
        }
        this.sb.setLength(this.sb.length() - 1);
        this.sb.append(newLineCSV);
        for (String s2 : contracts) {
            this.sb.append(s2).append(newLineCSV);
        }
    }

    public void toCSVError(ErrorMsg type, String msg) {
        this.sb.setLength(0);
        this.sb.append("error_type,error_msg");
        this.sb.append(newLineCSV);
        this.sb.append((Object)type).append(',').append(msg);
    }

    public void start() {
        this.sb.setLength(0);
        this.sb.append(this.headerString());
        this.sb.append(startLine);
    }

    public String getStart() {
        return this.headerString() + startLine;
    }

    public String getStart2() {
        return this.headerString2() + startLine;
    }

    public void start(String format) {
        this.sb.setLength(0);
        this.sb.append(this.headerString(format));
        this.sb.append(startLine);
    }

    public void start2(String format) {
        this.sb.setLength(0);
        this.sb.append(this.headerString2(format));
        this.sb.append(startLine);
    }

    public void addError() {
        this.sb.append("\t\t0\n");
        this.sb.append(" \t]\n}");
    }

    public void end() {
        this.sb.setLength(this.sb.length() - 1);
        this.sb.setCharAt(this.sb.length() - 1, '\n');
        this.sb.append(" \t]\n}");
    }

    public void write(char[] buff) {
        this.sb.getChars(0, this.sb.length(), buff, 0);
    }

    public int length() {
        return this.sb.length();
    }

    public void addTick(DataType[] format, int[] tick, int pTypeIndex) {
        this.sb.append(padding);
        for (int i = 0; i < tick.length; ++i) {
            if (i == pTypeIndex) continue;
            if (format[i].isPrice()) {
                PriceCalc.fmtPrice(this.sb, PriceCalc.getPriceDouble(tick[i], tick[pTypeIndex]), 4);
            } else if (format[i] == DataType.CONDITION) {
                this.sb.append(tick[i & 0xFF]);
            } else {
                this.sb.append(tick[i]);
            }
            this.sb.append(',');
        }
        this.sb.setCharAt(this.sb.length() - 1, ']');
        this.sb.append(',').append('\n');
    }

    public void endCSVContracts() {
        this.sb.setLength(this.sb.length() - 2);
        this.sb.append(newLineCSV);
        this.sb.append(" \t]\n}");
    }

    public void addTick2(DataType[] format, int[] tick, int pTypeIndex, int[] timeIndices, boolean prettyTime) {
        this.sb.append(padding);
        for (int i = 0; i < tick.length; ++i) {
            if (i == pTypeIndex) continue;
            if (format[i].isPrice()) {
                PriceCalc.fmtPrice(this.sb, PriceCalc.getPriceDouble(tick[i], tick[pTypeIndex]), PriceCalc.PLACES[tick[pTypeIndex]]);
            } else if (prettyTime && (format[i] == DataType.DATE || format[i] == DataType.EX_DATE || format[i] == DataType.ANN_DATE || format[i] == DataType.PAYMENT_DATE || format[i] == DataType.RECORD_DATE || format[i] == DataType.SPLIT_DATE)) {
                RestQueryMessage.addPrettyDate(tick[i], this.sb);
            } else if (prettyTime && (i == timeIndices[0] || i == timeIndices[1])) {
                RestQueryMessage.addPrettyTime(tick[i], this.sb);
            } else if (format[i] == DataType.CONDITION) {
                this.sb.append(tick[i] & 0xFF);
            } else {
                this.sb.append(tick[i]);
            }
            this.sb.append(',');
        }
        this.sb.setCharAt(this.sb.length() - 1, ']');
        this.sb.append(',').append('\n');
    }

    public void addTickStr(DataType[] format, String[] strTicks, int pTypeIndex, int[] timeIndices, boolean prettyTime) {
        this.sb.append(padding);
        for (int i = 0; i < strTicks.length && strTicks[i] != null; ++i) {
            if (strTicks[i].isEmpty()) {
                this.sb.append("NULL");
            } else if (prettyTime && format[i].isDate()) {
                RestQueryMessage.addPrettyDate(Integer.parseInt(strTicks[i]), this.sb);
            } else if (prettyTime && (i == timeIndices[0] || i == timeIndices[1])) {
                RestQueryMessage.addPrettyTime(Integer.parseInt(strTicks[i]), this.sb);
            } else if (format[i] == DataType.CONDITION) {
                this.sb.append(Integer.parseInt(strTicks[i]) & 0xFF);
            } else if (format[i] == DataType.SYMBOL && Character.isLowerCase(strTicks[i].charAt(0))) {
                this.sb.append(strTicks[i].substring(1));
            } else {
                this.sb.append(format[i] == DataType.SYMBOL_CHANGE_TYPE ? strTicks[i].replace(" ", "") : strTicks[i]);
            }
            this.sb.append(',');
        }
        this.sb.setCharAt(this.sb.length() - 1, ']');
        this.sb.append(',').append('\n');
    }

    public void addContractTick(DataType[] format, int[] tick, int pTypeIndex, Contract con) {
        this.sb.append(paddingStr);
        this.sb.append('{');
        this.sb.append('\n');
        this.sb.append(paddingStr).append('\t').append("\"tick\": [");
        for (int i = 0; i < tick.length; ++i) {
            if (i == pTypeIndex) continue;
            if (format[i].isPrice()) {
                PriceCalc.fmtPrice(this.sb, PriceCalc.getPriceDouble(tick[i], tick[pTypeIndex]), 4);
            } else {
                this.sb.append(tick[i]);
            }
            this.sb.append(',');
        }
        this.sb.setCharAt(this.sb.length() - 1, ']');
        this.sb.append(',').append('\n');
        this.sb.append(paddingStr).append('\t').append("\"contract\": {").append('\n');
        if (con.isOption()) {
            this.sb.append(paddingStr3).append("\"root\": \"").append(con.getRoot()).append('\"').append(',').append('\n');
            this.sb.append(paddingStr3).append("\"expiration\": ").append(con.getExp()).append(',').append('\n');
            this.sb.append(paddingStr3).append("\"strike\": ").append(con.getStrike()).append(',').append('\n');
            this.sb.append(paddingStr3).append("\"right\": \"").append(con.isCall() ? (char)'C' : 'P').append('\"').append('\n');
        } else {
            this.sb.append(paddingStr3).append("\"root\": \"").append(con.getRoot()).append('\"').append('\n');
        }
        this.sb.append(paddingStr).append('\t').append('}').append('\n');
        this.sb.append(paddingStr).append('}').append(',').append('\n');
    }

    public void addContractTicks(DataType[] format, FITReader fr, int pTypeIndex, Contract con) {
        this.sb.append(paddingStr);
        this.sb.append('{');
        this.sb.append('\n');
        this.sb.append(paddingStr).append('\t').append("\"ticks\": [").append('\n');
        while (fr.readTick() != null) {
            this.sb.append(paddingStr).append('\t').append('\t').append('[');
            int[] tick = fr.peek().data();
            for (int i = 0; i < tick.length; ++i) {
                if (i == pTypeIndex) continue;
                if (format[i].isPrice()) {
                    PriceCalc.fmtPrice(this.sb, PriceCalc.getPriceDouble(tick[i], tick[pTypeIndex]), 4);
                } else {
                    this.sb.append(tick[i]);
                }
                this.sb.append(',');
            }
            this.sb.setCharAt(this.sb.length() - 1, ']');
            this.sb.append(',').append('\n');
        }
        this.sb.setLength(this.sb.length() - 2);
        this.sb.append('\n').append(paddingStr).append('\t').append(']').append(',').append('\n');
        this.sb.append(paddingStr).append('\t').append("\"contract\": {").append('\n');
        if (con.isOption()) {
            this.sb.append(paddingStr3).append("\"root\": \"").append(con.getRoot()).append('\"').append(',').append('\n');
            this.sb.append(paddingStr3).append("\"expiration\": ").append(con.getExp()).append(',').append('\n');
            this.sb.append(paddingStr3).append("\"strike\": ").append(con.getStrike()).append(',').append('\n');
            this.sb.append(paddingStr3).append("\"right\": \"").append(con.isCall() ? (char)'C' : 'P').append('\"').append('\n');
        } else {
            this.sb.append(paddingStr3).append("\"root\": \"").append(con.getRoot()).append('\"').append('\n');
        }
        this.sb.append(paddingStr).append('\t').append('}').append('\n');
        this.sb.append(paddingStr).append('}').append(',').append('\n');
    }

    public int addContractTicks2(DataType[] format, FITReader fr, int pTypeIndex, Contract con, boolean prettyTime) {
        this.sb.append(paddingStr);
        this.sb.append('{');
        this.sb.append('\n');
        this.sb.append(paddingStr).append('\t').append("\"ticks\": [").append('\n');
        int ticksRead = 0;
        int[] timeIndices = new int[2];
        Arrays.fill(timeIndices, -1);
        for (int i = 0; i < format.length; ++i) {
            if (format[i] == DataType.MS_OF_DAY) {
                timeIndices[0] = i;
                continue;
            }
            if (format[i] != DataType.MS_OF_DAY2) continue;
            timeIndices[1] = i;
        }
        while (fr.readTick() != null) {
            this.sb.append(paddingStr).append('\t').append('\t').append('[');
            int[] tick = fr.peek().data();
            for (int i = 0; i < tick.length; ++i) {
                if (i == pTypeIndex) continue;
                if (format[i].isPrice()) {
                    PriceCalc.fmtPrice(this.sb, PriceCalc.getPriceDouble(tick[i], tick[pTypeIndex]), 4);
                } else if (prettyTime && (format[i] == DataType.DATE || format[i] == DataType.EX_DATE || format[i] == DataType.ANN_DATE || format[i] == DataType.PAYMENT_DATE || format[i] == DataType.RECORD_DATE || format[i] == DataType.SPLIT_DATE)) {
                    RestQueryMessage.addPrettyDate(tick[i], this.sb);
                } else if (prettyTime && (i == timeIndices[0] || i == timeIndices[1])) {
                    RestQueryMessage.addPrettyTime(tick[i], this.sb);
                } else {
                    this.sb.append(tick[i]);
                }
                this.sb.append(',');
            }
            this.sb.setCharAt(this.sb.length() - 1, ']');
            this.sb.append(',').append('\n');
            ++ticksRead;
        }
        this.sb.setLength(this.sb.length() - 2);
        this.sb.append('\n').append(paddingStr).append('\t').append(']').append(',').append('\n');
        this.sb.append(paddingStr).append('\t').append("\"contract\": {").append('\n');
        if (con.isOption()) {
            this.sb.append(paddingStr3).append("\"root\": \"").append(con.getRoot()).append('\"').append(',').append('\n');
            this.sb.append(paddingStr3).append("\"expiration\": ");
            if (prettyTime) {
                this.sb.append('\"');
                RestQueryMessage.addPrettyDate(con.getExp(), this.sb);
                this.sb.append('\"');
            } else {
                this.sb.append(con.getExp());
            }
            this.sb.append(',').append('\n');
            this.sb.append(paddingStr3).append("\"strike\": ").append(con.getStrike()).append(',').append('\n');
            this.sb.append(paddingStr3).append("\"right\": \"").append(con.isCall() ? (char)'C' : 'P').append('\"').append('\n');
        } else {
            this.sb.append(paddingStr3).append("\"root\": \"").append(con.getRoot()).append('\"').append('\n');
        }
        this.sb.append(paddingStr).append('\t').append('}').append('\n');
        this.sb.append(paddingStr).append('}').append(',').append('\n');
        return ticksRead;
    }

    public void addContractListFast(Contract con) {
        if (con.isOption()) {
            this.sb.append(paddingStr).append('[').append('\"').append(con.getRoot()).append('\"').append(',').append(con.getExp()).append(',').append(con.getStrike()).append(',').append('\"').append(con.isCall() ? (char)'C' : 'P').append('\"').append(']').append(',').append('\n');
        } else {
            this.sb.append(paddingStr).append('[').append(con.getRoot()).append(']').append(',').append('\n');
        }
    }

    public void addStr(String s2) {
        this.sb.append(paddingStr);
        this.sb.append('\"').append(s2).append('\"').append(',').append('\n');
    }

    public void addInt(String s2) {
        this.sb.append(paddingStr);
        this.sb.append(s2).append(',').append('\n');
    }

    public void addStr2(String s2) {
        this.sb.append(paddingStr);
        this.sb.append('\"').append(s2).append('\"').append(',').append('\n');
    }

    public void setNextPage(String s2) {
        this.nextPage = s2;
    }

    public String headerString() {
        return "{\n\t\"header\": {\n\t\t\"id\": " + this.id + ",\n\t\t\"latency_ms\": " + this.latency + ",\n\t\t\"error_type\": \"" + this.errorType + "\",\n\t\t\"error_msg\": \"" + this.errorMsg + "\",\n\t\t\"next_page\": \"" + this.nextPage + "\",\n\t\t\"format\": " + this.formatString() + "\n \t},\n";
    }

    public String headerString2() {
        return "{\n\t\"header\": {\n\t\t\"latency_ms\": " + this.latency + ",\n\t\t\"next_page\": \"" + this.nextPage + "\",\n\t\t\"format\": " + this.formatString() + "\n \t},\n";
    }

    public String headerString2(String format) {
        return "{\n\t\"header\": {\n\t\t\"latency_ms\": " + this.latency + ",\n\t\t\"format\": " + format + "\n \t},\n";
    }

    public String headerString(String format) {
        return "{\n\t\"header\": {\n\t\t\"id\": " + this.id + ",\n\t\t\"latency_ms\": " + this.latency + ",\n\t\t\"error_type\": \"" + this.errorType + "\",\n\t\t\"error_msg\": \"" + this.errorMsg + "\",\n\t\t\"next_page\": null,\n\t\t\"format\": " + format + "\n \t},\n";
    }

    private String formatString() {
        if (this.format == null) {
            return null;
        }
        StringBuilder out = new StringBuilder("[");
        for (DataType d : this.format) {
            out.append('\"').append(d.name().toLowerCase()).append('\"').append(',');
        }
        out.setCharAt(out.length() - 1, ']');
        return out.toString();
    }

    public String toString() {
        return this.sb.toString();
    }
}

