/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.cfg;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Scanner;
import net.thetadata.terminal.App;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;

public class CommandLine {
    private static final HelpFormatter formatter = new HelpFormatter();
    private static final String homeDir = System.getProperty("user.home");
    private final Options options;
    private final Options helpOptions;
    private final Console console;
    private String username;
    private String password;
    private File configFile;
    private File logDirectory;
    private int line;
    private boolean disableMdds = false;

    public CommandLine() {
        this(System.console());
    }

    CommandLine(Console console) {
        this.console = console;
        Option help = Option.builder("h").required(false).hasArg(false).desc("Print usage").longOpt("help").build();
        Option config = Option.builder().required(false).hasArg().argName("config.properties").desc("Configuration file; will use config_0.properties if not set").longOpt("config").build();
        Option logDir = Option.builder().required(false).hasArg().argName("log_directory").desc("Directory to store log files; defaults to ThetaData directory").longOpt("log-directory").build();
        Option creds = Option.builder().required(false).hasArg().argName("creds.txt").desc("A 2-line text file containing username and password, each on their own line").longOpt("creds-file").build();
        Option debug = Option.builder().longOpt("debug").required(false).hasArg(false).build();
        Option noMdds = Option.builder().longOpt("no-mdds").required(false).hasArg(false).build();
        this.options = new Options();
        this.helpOptions = new Options();
        this.options.addOption(help).addOption(config).addOption(logDir).addOption(creds).addOption(debug).addOption(noMdds);
        this.helpOptions.addOption(help).addOption(config).addOption(logDir).addOption(creds);
    }

    public void printUsage() {
        String newline = System.lineSeparator();
        formatter.printHelp(120, "java -jar ThetaTerminal.jar [options] [username password] [line]", "See: https://http-docs.thetadata.us/Articles/Performance-And-Tuning/Launch-Arguments.html" + newline + newline + "options:", this.helpOptions, newline + "Note: A subscription is required to use the ThetaTerminal");
    }

    public void parseArgs(String[] args) throws Exception {
        String[] remainingArgs;
        DefaultParser cmdParser = new DefaultParser();
        org.apache.commons.cli.CommandLine cmdLine = cmdParser.parse(this.options, args);
        if (cmdLine.hasOption("h")) {
            this.printUsage();
            System.exit(0);
        }
        String config = cmdLine.getOptionValue("config");
        String logDir = cmdLine.getOptionValue("log-directory");
        String creds = cmdLine.getOptionValue("creds-file");
        if (cmdLine.hasOption("debug")) {
            System.setProperty("debug_console", "ENABLE");
        }
        if (cmdLine.hasOption("no-mdds")) {
            this.disableMdds = true;
        }
        if ((remainingArgs = cmdLine.getArgs()).length == 0) {
            if (creds == null) {
                this.getCredsFromConsole();
            }
        } else if (remainingArgs.length == 1) {
            if (remainingArgs[0].startsWith("creds=")) {
                fields = remainingArgs[0].split("=");
                this.readCredsFile(new File(fields[1]));
            } else {
                try {
                    this.line = Integer.parseInt(remainingArgs[0]);
                }
                catch (NumberFormatException e) {
                    throw new IOException(e);
                }
                if (creds == null) {
                    this.getCredsFromConsole();
                }
            }
        } else if (remainingArgs.length == 2) {
            if (remainingArgs[0].startsWith("creds=")) {
                fields = remainingArgs[0].split("=");
                this.readCredsFile(new File(fields[1]));
                try {
                    this.line = Integer.parseInt(remainingArgs[1]);
                }
                catch (NumberFormatException e) {
                    throw new IOException(e);
                }
            } else {
                this.username = remainingArgs[0];
                this.password = remainingArgs[1];
            }
        } else {
            this.username = remainingArgs[0];
            this.password = remainingArgs[1];
            try {
                this.line = Integer.parseInt(remainingArgs[2]);
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
        }
        if (creds != null) {
            if (this.username != null || this.password != null) {
                throw new ParseException(String.format("A credentials file was specified (%s), and a username and password also provided; please use one or the other", creds));
            }
            this.readCredsFile(new File(creds));
        }
        if (config != null && this.line != 0) {
            throw new ParseException("A config file and line were specified. Please favor using the --config argument over lines");
        }
        if (config == null) {
            config = Path.of(homeDir, "ThetaData", "ThetaTerminal", "config_" + this.line + ".properties").toString();
        }
        if (logDir == null) {
            logDir = Path.of(homeDir, "ThetaData", "ThetaTerminal", "logs").toString();
        }
        this.configFile = new File(config);
        this.logDirectory = new File(logDir);
        System.setProperty("td.logDir", this.logDirectory.getAbsolutePath());
        URI log4jConfigFile = App.class.getClassLoader().getResource("no-auto-load-log4j2.xml").toURI();
        Log4jContextFactory factory = (Log4jContextFactory)LogManager.getFactory();
        ContextSelector ctxSelector = factory.getSelector();
        ctxSelector.getContext(null, null, false).setConfigLocation(log4jConfigFile);
        ctxSelector.getContext(App.class.getName(), App.class.getClassLoader(), false).setConfigLocation(log4jConfigFile);
    }

    private void readCredsFile(File credsFile) throws IOException {
        List<String> lines = Files.readAllLines(credsFile.toPath());
        if (lines.size() < 2) {
            throw new IOException("Incorrect number of lines in creds file. The username and password must be on their own lines.");
        }
        this.username = lines.get(0);
        this.password = lines.get(1);
    }

    private void getCredsFromConsole() throws ParseException {
        System.out.println("Please provide your username (email) and press (ENTER). Leave blank for free access.");
        this.username = this.console == null ? new Scanner(System.in).nextLine() : this.console.readLine();
        if (this.username.isBlank()) {
            throw new ParseException("You must provide an email even for free accounts");
        }
        System.out.println("Please provide your password and press (ENTER). Leave blank for free access.");
        this.password = this.console == null ? new Scanner(System.in).nextLine() : new String(this.console.readPassword());
        if (this.password.isBlank()) {
            this.password = "default";
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public int getLine() {
        return this.line;
    }

    public boolean noMdds() {
        return this.disableMdds;
    }
}

