/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.http;

import com.google.gson.JsonObject;
import net.thetadata.enums.SecType;
import net.thetadata.terminal.App;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class FullTradeWS
extends WebSocketAdapter {
    private Session session;
    private final JsonObject msg = new JsonObject();
    private final JsonObject header = new JsonObject();
    private final JsonObject contract = new JsonObject();
    private final JsonObject trade = new JsonObject();
    private final JsonObject quote = new JsonObject();
    private final JsonObject ohlc = new JsonObject();

    public FullTradeWS() {
        this.header.addProperty("type", "STATUS");
        this.header.addProperty("status", "");
        if (App.getStreamClient() == null || !App.getStreamClient().isConnected()) {
            this.header.addProperty("status", "DISCONNECTED");
        } else if (!App.getStreamClient().isVerified()) {
            this.header.addProperty("status", "UNVERIFIED");
        } else {
            this.header.addProperty("status", "CONNECTED");
        }
        this.msg.add("header", this.header);
        this.msg.add("contract", this.contract);
        this.msg.add("trade", this.trade);
        this.msg.add("quote", this.quote);
        this.msg.add("ohlc", this.ohlc);
    }

    @Override
    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        this.session = session;
        try {
            if (App.getStreamClient() != null) {
                App.getStreamClient().requestFullTradeWS(SecType.OPTION, 0, false, this);
            }
            session.getRemote().sendString(this.msg.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onWebSocketClose(int statusCode, String reason) {
        this.session = null;
        super.onWebSocketClose(statusCode, reason);
    }

    @Override
    public void onWebSocketText(String message) {
        super.onWebSocketText(message);
    }
}

