/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.loadtest;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.thetadata.terminal.App;
import net.thetadata.terminal.api.types.MessageType;
import net.thetadata.terminal.loadtest.MddsClient;
import net.thetadata.terminal.types.DataRequest;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;

public class LoadTest {
    private static Logger logger = LogManager.getLogger(LoadTest.class);
    private static final HelpFormatter formatter = new HelpFormatter();

    public static void main(String[] args) throws IOException, URISyntaxException, InterruptedException {
        Integer port;
        String host;
        Integer numReqs;
        Integer numThreads;
        Options options = new Options();
        options.addOption(Option.builder("h").required(false).hasArg(false).desc("Print usage").longOpt("help").build());
        options.addOption(Option.builder("n").required(true).hasArg(true).argName("numThreads").desc("How many threads to use").longOpt("threads").type(Integer.class).build());
        options.addOption(Option.builder("c").required(true).hasArg(true).argName("requestCount").desc("Number of requests to make for each thread").longOpt("count").type(Integer.class).build());
        options.addOption(Option.builder("H").required(false).hasArg(true).argName("host").desc("Host to connect to; default nj-a.thetadata.us").longOpt("host").build());
        options.addOption(Option.builder("p").required(false).hasArg(true).argName("port").desc("Port to connect to; default 12200").longOpt("port").type(Integer.class).build());
        DefaultParser cmdParser = new DefaultParser();
        URI log4jConfigFile = App.class.getClassLoader().getResource("no-auto-load-testing-log4j2.xml").toURI();
        Log4jContextFactory factory = (Log4jContextFactory)LogManager.getFactory();
        ContextSelector ctxSelector = factory.getSelector();
        ctxSelector.getContext(null, null, false).setConfigLocation(log4jConfigFile);
        ctxSelector.getContext(App.class.getName(), App.class.getClassLoader(), false).setConfigLocation(log4jConfigFile);
        try {
            CommandLine cmdLine = cmdParser.parse(options, args);
            numThreads = (Integer)cmdLine.getParsedOptionValue("n");
            numReqs = (Integer)cmdLine.getParsedOptionValue("c");
            host = cmdLine.getOptionValue("H", "nj-a.thetadata.us");
            port = cmdLine.getParsedOptionValue('p', Integer.valueOf(12200));
        }
        catch (ParseException exp) {
            formatter.printHelp("LoadTest", options);
            return;
        }
        logger.info("Config: threads={} count={} host={} port={}", (Object)numThreads, (Object)numReqs, (Object)host, (Object)port);
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        ConcurrentLinkedQueue latencies = new ConcurrentLinkedQueue();
        AtomicInteger finishCount = new AtomicInteger();
        for (int i = 0; i < numThreads; ++i) {
            exec.execute(() -> {
                try (MddsClient client = new MddsClient(host, port);){
                    DataRequest request = new DataRequest(MessageType.LAST_BULK, 0L, "SEC=option&REQ=203&root=SPXW&exp=0&version=2");
                    ArrayList<Long> tempLatencies = new ArrayList<Long>();
                    for (int x = 0; x < numReqs; ++x) {
                        long startMs = System.currentTimeMillis();
                        client.makeRequest(request);
                        tempLatencies.add(System.currentTimeMillis() - startMs);
                        Thread.sleep(25L);
                    }
                    latencies.addAll(tempLatencies);
                }
                catch (Exception e) {
                    logger.error("Error executing thread", (Throwable)e);
                }
                logger.info("finished");
                finishCount.incrementAndGet();
            });
        }
        while (finishCount.get() < numThreads) {
            Thread.sleep(50L);
        }
        logger.info("Completed all threads");
        ArrayList finishedLatencies = new ArrayList(latencies);
        double average = finishedLatencies.stream().mapToDouble(a -> a.longValue()).average().getAsDouble();
        double min2 = finishedLatencies.stream().mapToDouble(a -> a.longValue()).min().getAsDouble();
        double max = finishedLatencies.stream().mapToDouble(a -> a.longValue()).max().getAsDouble();
        ArrayList<Double> diffLatencies = new ArrayList<Double>();
        for (Long l : finishedLatencies) {
            diffLatencies.add(Math.abs((double)l.longValue() - average));
        }
        double std = diffLatencies.stream().mapToDouble(a -> a).average().getAsDouble();
        logger.info("avg: " + average);
        logger.info("std: " + std);
        logger.info("min: " + min2);
        logger.info("max: " + max);
    }
}

