/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.client;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.thetadata.enums.ReqArg;
import net.thetadata.terminal.App;
import net.thetadata.terminal.api.types.MessageType;
import net.thetadata.terminal.types.CallbackCache;
import net.thetadata.terminal.types.DataRequest;
import net.thetadata.terminal.types.Version;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientServerV2 {
    private static final Logger logger = LogManager.getLogger(ClientServerV2.class);
    private static volatile ServerSocket server;
    private static Socket api;
    private static OutputStream out;
    private static BufferedReader in;
    private static final ByteBuffer header;
    private static volatile String lastIP;

    public static void init(int port) throws IOException {
        server = new ServerSocket();
        boolean attemptSuccessful = false;
        try {
            logger.debug("Starting server on port {}", (Object)port);
            server.bind(new InetSocketAddress("0.0.0.0", port));
        }
        catch (BindException e) {
            logger.warn("Existing terminal instance found. Attempting to terminate it -->  ");
            try {
                Socket s2 = new Socket("0.0.0.0", port);
                PrintWriter pw = new PrintWriter(s2.getOutputStream());
                pw.println("MSG_CODE=" + MessageType.KILL.code());
                pw.flush();
                s2.close();
                for (int i = 0; i < 50; ++i) {
                    try {
                        Thread.sleep(100L);
                        server = new ServerSocket();
                        server.bind(new InetSocketAddress("127.0.0.1", port));
                        attemptSuccessful = true;
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!attemptSuccessful) {
                    throw new ConnectException("");
                }
                logger.info("Termination successful.");
            }
            catch (Exception x) {
                logger.error("An instance of the Theta Terminal is already running or the port " + port + " is in use or this terminal was unable to terminate the old one. Please terminate any existing instances of the Theta Terminal or python scripts.", (Throwable)x);
                System.exit(1);
            }
        }
        new Thread(ClientServerV2::handleConnections).start();
    }

    public static synchronized void sendMsg(MessageType type, long id, short latency, short error, byte fmtLen, ByteBuffer data) throws IOException {
        if (out == null || type == MessageType.SESSION_TOKEN || type == MessageType.CREDENTIALS) {
            return;
        }
        header.clear();
        header.putShort(type.code());
        header.putLong(id);
        header.putShort(latency);
        header.putShort(error);
        header.put((byte)0);
        header.put(fmtLen);
        header.putInt(data.limit());
        out.write(header.array());
        out.write(data.array(), 0, data.limit());
        out.flush();
        data.clear();
    }

    public static void handleMessages() {
        boolean isFirst = true;
        try {
            while (api != null) {
                String s2 = in.readLine();
                if (s2 == null) {
                    return;
                }
                DataRequest d = new DataRequest(s2);
                if (isFirst && d.getMsgType() != MessageType.KILL) {
                    logger.warn("You are using the Python API! Consider using the REST or WebSocket API for better performance and more features: https://http-docs.thetadata.us. These APIs can be used in any language.");
                    isFirst = false;
                    if (!d.hasArg(ReqArg.VERSION)) {
                        logger.info("--------------------------------------------------------------------------------------------------\n");
                        logger.info("Your API is out of date! Please update your Python API to the latest version: 0.9.11");
                        logger.info("This API will still run, but may not function as expected.");
                        logger.info("To upgrade, type one of the following inside your terminal:");
                        logger.info("  python -m pip install --upgrade thetadata");
                        logger.info("  pip install thetadata\n");
                        logger.info("--------------------------------------------------------------------------------------------------");
                    } else {
                        Version terminal;
                        Version api = new Version(d.getStr(ReqArg.VERSION));
                        if (api.compareTo(terminal = new Version("0.9.11")) >= 0) continue;
                        logger.info("--------------------------------------------------------------------------------------------------\n");
                        logger.info("Your API (v" + d.getStr(ReqArg.VERSION) + ") is out of date! Please update your Python API to the latest version: 0.9.11");
                        logger.info("This API will still run, but may not function as expected.");
                        logger.info("To upgrade, type one of the following inside your terminal:");
                        logger.info("  python -m pip install --upgrade thetadata");
                        logger.info("  pip install thetadata\n");
                        logger.info("--------------------------------------------------------------------------------------------------");
                        continue;
                    }
                }
                if (d.hasArg(ReqArg.VERSION)) continue;
                if (d.getMsgType() == MessageType.KILL) {
                    ExecutorService exec = Executors.newFixedThreadPool(1);
                    exec.submit(() -> logger.error("Shutting down..."));
                    try {
                        exec.awaitTermination(1L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        logger.error("error", (Throwable)e);
                    }
                    System.exit(0);
                    continue;
                }
                if (!App.getMdds().isConnected()) {
                    ClientServerV2.sendMsg(MessageType.ERROR, d.getId(), (short)0, (short)1, (byte)0, ByteBuffer.wrap("Disconnected from Theta Data.".getBytes()));
                    continue;
                }
                CallbackCache.putReq(d.getId(), d);
                App.getMdds().write(d, false);
            }
        }
        catch (IOException e) {
            if (e instanceof SocketException) {
                logger.error("Lost connection to API client.");
            }
            logger.error("Unknown error", (Throwable)e);
        }
    }

    private static void handleConnections() {
        while (App.getMdds() == null || !App.getMdds().isConnected()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error("Connection interrupted", (Throwable)e);
            }
        }
        try {
            while (true) {
                if (!ClientServerV2.singleIPCheck(api = server.accept())) {
                    continue;
                }
                in = new BufferedReader(new InputStreamReader(api.getInputStream()));
                out = new BufferedOutputStream(api.getOutputStream());
                ClientServerV2.handleMessages();
            }
        }
        catch (IOException e) {
            logger.debug("IOException handling messages", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static boolean singleIPCheck(Socket s2) throws IOException {
        if (lastIP == null) {
            lastIP = s2.getInetAddress().getHostName();
            return true;
        }
        if (App.DISABLE_IP_LIM) {
            return true;
        }
        if (!lastIP.equals(s2.getInetAddress().getHostName())) {
            s2.close();
            logger.warn("Closing HTTP connection because the IP {} differs from the accept IP of {}", (Object)s2.getInetAddress().getHostName(), (Object)lastIP);
            return false;
        }
        return true;
    }

    static {
        header = ByteBuffer.allocate(20);
    }
}

