/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.dev;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class LatencyOverTime {
    private static List<String> symbols = new ArrayList<String>();
    private static final AtomicLong count = new AtomicLong();
    private static final AtomicLong vol = new AtomicLong();

    public static void main(String[] args) throws Exception {
        int minDate = 20231201;
        URL listSymbols = new URL("http://127.0.0.1:25510/v2/list/roots/option");
        JsonObject symbolsObj = JsonParser.parseString(new String(listSymbols.openStream().readAllBytes())).getAsJsonObject();
        for (JsonElement sym : symbolsObj.get("response").getAsJsonArray().asList()) {
            symbols.add(sym.getAsString());
        }
        symbols = List.of("SPX", "SPXW", "XSP", "VIX", "VIXW", "RUT", "RUTW");
        URL listTradingDays = new URL("http://127.0.0.1:25510/v2/list/dates/stock/quote?root=AAPL");
        JsonObject tradingDays = JsonParser.parseString(new String(listTradingDays.openStream().readAllBytes())).getAsJsonObject();
        JsonArray dates = tradingDays.get("response").getAsJsonArray();
        int threads = 8;
        ArrayList<Thread> join = new ArrayList<Thread>();
        for (int x = 0; x < dates.size(); ++x) {
            int date = dates.get(x).getAsInt();
            if (date < 20231201) continue;
            int i = 0;
            while (i < 8) {
                int id = i++;
                join.add(new Thread(() -> {
                    try {
                        long start = System.currentTimeMillis();
                        LatencyOverTime.getHistData(date, 8, id);
                        System.out.println(String.valueOf(LocalDateTime.now()) + ": finished date: " + date + " latency: " + (System.currentTimeMillis() - start) + "ms vol: " + vol.get() / 1024L + "KB");
                    }
                    catch (Exception e) {
                        System.err.println("ERR for date: 20231227");
                    }
                }));
                ((Thread)join.get(join.size() - 1)).start();
            }
            for (Thread t2 : join) {
                t2.join();
            }
            System.out.println(String.valueOf(LocalDateTime.now()) + " FULLY PROCESSED DATE: " + date + " count: " + String.valueOf(count));
        }
    }

    public static void getHistData(int date, int len, int id) throws Exception {
        URL listCons = new URL("http://127.0.0.1:25511/v2/list/contracts/option/quote?start_date=" + date);
        JsonObject conObj = JsonParser.parseString(new String(listCons.openStream().readAllBytes())).getAsJsonObject();
        JsonArray cons = conObj.get("response").getAsJsonArray();
        for (int i = 0; i < cons.size(); ++i) {
            String root = cons.get(i).getAsJsonArray().get(0).getAsString();
            if (!symbols.contains(root) || i % len != id) continue;
            count.incrementAndGet();
            int exp = cons.get(i).getAsJsonArray().get(1).getAsInt();
            int strike = cons.get(i).getAsJsonArray().get(2).getAsInt();
            String right = cons.get(i).getAsJsonArray().get(3).getAsString();
            URL getData = new URL("http://127.0.0.1:25511/v2/hist/option/quote?start_date=" + date + "&end_date=" + date + "&root=" + root + "&exp=" + exp + "&strike=" + strike + "&right=" + right + "&ivl=60000");
            byte[] data = getData.openStream().readAllBytes();
            vol.addAndGet(data.length);
            JsonObject responseObj = JsonParser.parseString(new String(data)).getAsJsonObject();
            int n = responseObj.get("header").getAsJsonObject().get("latency_ms").getAsInt();
        }
    }
}

