/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.dev;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import javax.websocket.ClientEndpoint;
import javax.websocket.ContainerProvider;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import net.thetadata.terminal.types.utils.Utils;

@ClientEndpoint
public class Util {
    Session userSession = null;

    @OnOpen
    public void onOpen(Session userSession) {
        this.userSession = userSession;
    }

    @OnMessage
    public void onMessage(String message) {
        JsonObject obj = JsonParser.parseString(message).getAsJsonObject();
        if (obj.get("header").getAsJsonObject().get("type").getAsString().equals("TRADE") && obj.toString().contains("INDEX")) {
            System.out.println(Utils.currentDayMS() + " " + String.valueOf(obj));
        }
    }

    public void sendMessage(String message) {
        this.userSession.getAsyncRemote().sendText(message);
    }

    public static void main(String[] args) throws Exception {
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        Util m4 = new Util();
        Session session = container.connectToServer(m4, new URI("ws://127.0.0.1:25520/v1/events"));
        File reqFile = new File("C:\\Users\\baile\\Downloads\\events.json");
        JsonArray arr = JsonParser.parseString(new String(Files.readAllBytes(reqFile.toPath()))).getAsJsonArray();
        for (int i = 0; i < arr.size(); ++i) {
            m4.sendMessage(arr.get(i).toString());
        }
        while (true) {
            Thread.sleep(60000L);
        }
    }
}

