/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.http;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.thetadata.enums.ReqType;
import net.thetadata.enums.SecType;
import net.thetadata.terminal.App;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class WSSubscribe
extends WebSocketAdapter {
    private Session session;

    @Override
    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        this.session = session;
    }

    @Override
    public void onWebSocketClose(int statusCode, String reason) {
        this.session = null;
        super.onWebSocketClose(statusCode, reason);
    }

    @Override
    public void onWebSocketText(String message) {
        try {
            super.onWebSocketText(message);
            JsonObject obj = JsonParser.parseString(message).getAsJsonObject();
            boolean isBulk = obj.get("msg_type").getAsString().toUpperCase().contains("BULK");
            boolean isAdd = obj.get("add").getAsBoolean();
            SecType sec = SecType.valueOf(obj.get("sec_type").getAsString().toUpperCase());
            ReqType req = ReqType.valueOf(obj.get("req_type").getAsString().toUpperCase());
            int id = obj.get("id").getAsInt();
            if (isBulk && req == ReqType.TRADE) {
                App.getStreamClient().requestFullTradeWS(SecType.OPTION, id, !isAdd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

