/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.net;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.thetadata.Tick;

public class FITReader {
    private static final int[] POWERS_OF_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private byte[] data;
    private final ByteBuffer intBuff = ByteBuffer.allocate(4);
    private final StringBuilder sb = new StringBuilder(64);
    private final String[] stringTick = new String[64];
    private static final byte NEXT = 0;
    private static final byte END = 1;
    private int[] buffer = new int[512];
    private int pos;
    private int[] alloc;
    private Tick tick;
    private boolean isFirst;
    private int lim;

    public void open(byte[] data, int lim) {
        this.isFirst = true;
        this.data = data;
        this.pos = 0;
        this.lim = lim;
    }

    public void open(byte[] data) {
        this.isFirst = true;
        this.data = data;
        this.pos = 0;
        this.lim = data.length;
    }

    public int readChanges(int[] alloc) {
        boolean isDate;
        if (this.pos >= this.data.length) {
            return -1;
        }
        int spacing = 5;
        int x = 0;
        int count = 0;
        int idx = 0;
        boolean negative = false;
        boolean bl = isDate = this.data[this.pos] == -50;
        if (isDate) {
            ++this.pos;
        }
        for (int k = this.pos; k < this.lim; ++k) {
            int i;
            int z;
            int t2 = this.data[k] < 0 ? this.data[k] + 256 : this.data[k];
            int f = t2 >> 4;
            int s2 = t2 & 0xF;
            if (f == 11) {
                for (z = x - 1; z >= 0; --z) {
                    count += this.buffer[z] * POWERS_OF_10[x - z - 1];
                }
                alloc[idx++] = negative ? count * -1 : count;
                x = 0;
                negative = false;
                count = 0;
            } else if (f == 14) {
                negative = true;
            } else if (f == 12) {
                for (z = x - 1; z >= 0; --z) {
                    count += this.buffer[z] * POWERS_OF_10[x - z - 1];
                }
                alloc[idx++] = negative ? count * -1 : count;
                x = 0;
                negative = false;
                count = 0;
                for (i = spacing - 1; i >= idx; --i) {
                    alloc[i] = 0;
                }
                idx = spacing;
            } else {
                if (f == 13) {
                    for (z = x - 1; z >= 0; --z) {
                        count += this.buffer[z] * POWERS_OF_10[x - z - 1];
                    }
                    alloc[idx++] = negative ? count * -1 : count;
                    this.pos = ++k;
                    return isDate ? 0 : idx;
                }
                this.ensureBufferCap(x);
                this.buffer[x++] = f;
            }
            if (s2 == 11) {
                for (z = x - 1; z >= 0; --z) {
                    count += this.buffer[z] * POWERS_OF_10[x - z - 1];
                }
                alloc[idx++] = negative ? count * -1 : count;
                x = 0;
                negative = false;
                count = 0;
                continue;
            }
            if (s2 == 14) {
                negative = true;
                continue;
            }
            if (s2 == 12) {
                for (z = x - 1; z >= 0; --z) {
                    count += this.buffer[z] * POWERS_OF_10[x - z - 1];
                }
                alloc[idx++] = negative ? count * -1 : count;
                x = 0;
                negative = false;
                count = 0;
                for (i = spacing - 1; i >= idx; --i) {
                    alloc[i] = 0;
                }
                idx = spacing;
                continue;
            }
            if (s2 == 13) {
                for (z = x - 1; z >= 0; --z) {
                    count += this.buffer[z] * POWERS_OF_10[x - z - 1];
                }
                alloc[idx++] = negative ? count * -1 : count;
                this.pos = ++k;
                return isDate ? 0 : idx;
            }
            this.ensureBufferCap(x);
            this.buffer[x++] = s2;
        }
        return -1;
    }

    private void ensureBufferCap(int x) {
        if (x >= this.buffer.length) {
            int[] out = new int[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, out, 0, this.buffer.length);
            this.buffer = out;
        }
    }

    public Tick readTick() {
        if (this.isFirst) {
            this.alloc = new int[64];
            this.isFirst = false;
            int size = this.readChanges(this.alloc);
            if (size == -1) {
                return null;
            }
            this.alloc = Arrays.copyOfRange(this.alloc, 0, size);
            this.tick = new Tick(size).read(this.alloc);
            return this.tick;
        }
        int size = this.readChanges(this.alloc);
        if (size == this.tick.data().length) {
            this.tick.read(this.alloc);
            return this.tick;
        }
        if (size == -1) {
            return null;
        }
        this.tick.read(this.alloc, this.tick, size);
        return this.tick;
    }

    public String[] readStringTick() {
        if (this.readTick() == null) {
            return null;
        }
        int tickCount = 0;
        block0: for (int i : this.tick.data()) {
            this.intBuff.clear();
            this.intBuff.putInt(i);
            for (byte b : this.intBuff.array()) {
                if (b == 0) break;
                if (b == 1) {
                    this.stringTick[tickCount++] = this.sb.toString();
                    this.sb.setLength(0);
                    continue block0;
                }
                this.sb.append((char)b);
            }
        }
        return this.stringTick;
    }

    public boolean hasRemaining() {
        return this.pos < this.data.length - 1;
    }

    public void isFirst(boolean isFirst) {
        this.isFirst = isFirst;
    }

    public Tick peek() {
        return this.tick;
    }
}

