/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.net;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.thetadata.enums.RemoveReason;
import net.thetadata.terminal.App;
import net.thetadata.terminal.api.types.MessageType;
import net.thetadata.terminal.client.ClientServerV2;
import net.thetadata.terminal.flatfiles.FileBuilder;
import net.thetadata.terminal.fpss.Interp3;
import net.thetadata.terminal.io.Packet;
import net.thetadata.terminal.net.PacketStream;
import net.thetadata.terminal.types.CallbackCache;
import net.thetadata.terminal.types.DataRequest;
import net.thetadata.terminal.types.ErrorMsg;

public class MDDSClient {
    private Timer pinger;
    private String host;
    private String pass;
    private final List<String> hosts;
    private byte[] token;
    private String user;
    private RemoveReason last;
    private volatile String perms;
    private final AtomicBoolean isConnected = new AtomicBoolean();
    private final AtomicBoolean foundServer = new AtomicBoolean();
    private ByteBuffer data = ByteBuffer.allocate(0x2000000);
    private SSLSocket client;
    private volatile PacketStream ch;
    private final ConcurrentHashMap<Long, Long> restRequests = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Long> restRequestsV2 = new ConcurrentHashMap();
    private final ExecutorService exec;
    private static final AtomicBoolean madeConnect = new AtomicBoolean();
    private final int reconnectWait;

    public MDDSClient(int reconnectWait, int concurrency, String ... hostnames) throws IOException {
        MDDSClient.createTrust();
        this.hosts = Arrays.asList(hostnames);
        this.exec = Executors.newFixedThreadPool(Math.min(32, concurrency));
        this.reconnectWait = reconnectWait;
        if (!this.findAndConnectToServer()) {
            App.logger.error("[MDDS] Unable to connect to any listed query-based servers. Please ensure you are not trying to use the test server and there is no scheduled maintenance. Theta Terminal will attempt to connect to an available server every " + reconnectWait + "ms...");
            while (!this.findAndConnectToServer()) {
                try {
                    Thread.sleep(reconnectWait);
                }
                catch (Exception e) {
                    App.logger.debug("interrupt", (Throwable)e);
                }
            }
        }
        this.foundServer.set(true);
    }

    public MDDSClient(int concurrency, MDDSClient old) {
        this.hosts = old.hosts;
        this.token = old.getToken();
        this.reconnectWait = old.reconnectWait;
        this.exec = Executors.newFixedThreadPool(Math.min(32, concurrency));
    }

    public boolean findAndConnectToServer() {
        for (String s2 : this.hosts) {
            try {
                String[] t2 = s2.split(":");
                this.connect(t2[0], Integer.parseInt(t2[1]));
                this.startMessageProcessing();
                this.host = s2;
                return true;
            }
            catch (IOException e) {
                App.logger.debug("Involuntary disconnect: ", (Throwable)e);
                if (!(e instanceof SocketException) || !(e.getCause() instanceof NoSuchAlgorithmException)) continue;
                App.logger.error("Java does not recognize encryption the algorithm. Please try using a newer version of java.", (Throwable)e);
            }
            catch (Exception e) {
                App.logger.error("ERROR", (Throwable)e);
                App.logger.error("Unable to connect to: " + s2 + " because of the exception above. Attempting to connect to another server...");
            }
        }
        return false;
    }

    private void connect(String hostname, int port) throws IOException {
        this.client = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
        this.client.setTcpNoDelay(true);
        this.client.connect(new InetSocketAddress(hostname, port), 2000);
        this.client.setReceiveBufferSize(0x100000);
        this.client.startHandshake();
        this.ch = new PacketStream(this.client.getInputStream(), this.client.getOutputStream());
    }

    public void login(String user, String pass) {
        this.user = user;
        this.pass = pass;
        byte[] userBytes = user.getBytes();
        byte[] passBytes = pass.getBytes();
        App.logger.info("[MDDS] Attempting login as " + user);
        ByteBuffer out = ByteBuffer.allocate(3 + userBytes.length + passBytes.length);
        out.put((byte)0);
        out.putShort((short)userBytes.length);
        out.put(userBytes);
        out.put(passBytes);
        this.write(MessageType.CREDENTIALS, new String(out.array()));
    }

    public void login(MDDSClient old) {
        this.login(old.user, old.pass);
    }

    public void sendVersion() {
        Properties systemProperties = System.getProperties();
        Map<String, String> versionMap = systemProperties.entrySet().stream().filter(entry -> {
            String key = entry.getKey().toString();
            return (key.startsWith("java.") || key.startsWith("os.")) && !key.contains("path");
        }).collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        versionMap.put("terminal.version", String.format("%s-%s", "1.8.6", "A"));
        Gson gson = new Gson();
        String json = gson.toJson(versionMap);
        byte[] jsonBytes = json.getBytes();
        ByteBuffer out = ByteBuffer.allocate(4 + jsonBytes.length);
        out.putInt(jsonBytes.length);
        out.put(jsonBytes);
        this.write(MessageType.VERSION, out);
    }

    public boolean write(MessageType msg, ByteBuffer data) {
        return this.write(msg, -1L, data);
    }

    public boolean write(MessageType msg, long id, ByteBuffer data) {
        try {
            this.ch.write(msg, id, data);
            return true;
        }
        catch (IOException e) {
            this.close();
            return false;
        }
    }

    public boolean write(MessageType msg, String s2) {
        return this.write(msg, -1L, ByteBuffer.wrap(s2.getBytes()));
    }

    public boolean write(DataRequest req, boolean isREST) {
        if (isREST) {
            this.restRequests.put(req.getId(), req.getId());
        }
        return this.write(req.getMsgType(), req.getId(), ByteBuffer.wrap(req.toString().getBytes()));
    }

    public boolean writeV2(DataRequest req, boolean isREST) {
        if (isREST) {
            this.restRequestsV2.put(req.getId(), req.getId());
        }
        return this.write(req.getMsgType(), req.getId(), ByteBuffer.wrap(req.toString().getBytes()));
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            App.logger.warn("", (Throwable)e);
        }
    }

    private void startMessageProcessing() {
        new Thread(() -> {
            try {
                while (true) {
                    this.processMessage(this.ch.read());
                }
            }
            catch (IOException e) {
                this.close();
                this.handleInvoluntaryDisconnect();
                return;
            }
            catch (Exception e) {
                App.logger.debug("ERROR", (Throwable)e);
                App.logger.error("An unexpected error has occurred. Attempting to reconnect to Theta Data...");
                this.close();
                this.handleInvoluntaryDisconnect();
                return;
            }
        }).start();
    }

    private void processMessage(Packet p) throws Exception {
        if (p == null || p.clientMsg() == null) {
            App.logger.error("Null packet msg");
            return;
        }
        switch (p.clientMsg()) {
            case FLAT_FILE: {
                try {
                    FileBuilder.handleIncomingData(p);
                }
                catch (Exception e) {
                    try {
                        App.logger.error(e);
                        App.getRestServer().sendErrorV2(ErrorMsg.TERMINAL_PARSE, p.id(), "Please check your terminal log and send the error to support.");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        FileBuilder.nuke(p.id());
                    }
                    catch (Exception i) {
                        App.logger.debug("Error nuking: ", (Throwable)i);
                    }
                }
                return;
            }
            case FLAT_FILE_END: {
                try {
                    App.getRestServer().sendMsgTxt(MessageType.FLAT_FILE_END, p.id(), FileBuilder.handleFinish(p));
                }
                catch (Exception e) {
                    try {
                        App.getRestServer().sendErrorV2(ErrorMsg.TERMINAL_PARSE, p.id(), "Please check your terminal log and send the error to support.");
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                }
                try {
                    FileBuilder.nuke(p.id());
                }
                catch (Exception e) {
                    App.logger.debug("Error nuking: ", (Throwable)e);
                }
                return;
            }
            case PING: {
                return;
            }
            case LAST_BULK: {
                if (this.restRequestsV2.get(p.id()) != null || this.restRequests.get(p.id()) != null) {
                    this.exec.submit(() -> {
                        try {
                            if (this.restRequestsV2.get(p.id()) != null) {
                                this.restRequestsV2.remove(p.id());
                                App.getRestServer().sendMsgBulkHistV2(p.id(), p.data(), false);
                            } else if (this.restRequests.get(p.id()) != null) {
                                this.restRequests.remove(p.id());
                                App.getRestServer().sendMsgBulk(p.clientMsg(), p.id(), p.data());
                            } else {
                                App.logger.error("Cannot find requests callback information for: " + p.id());
                            }
                        }
                        catch (Exception e) {
                            App.logger.error("ERROR", (Throwable)e);
                            try {
                                App.getRestServer().sendErrorV2(ErrorMsg.TERMINAL_PARSE, p.id(), "Please check your terminal log and send the error to support.");
                            }
                            catch (Exception x) {
                                App.logger.error("error with request: " + String.valueOf((Object)p.clientMsg()), (Throwable)x);
                            }
                        }
                    });
                    return;
                }
            }
            case HIST_BULK: {
                if (this.restRequestsV2.get(p.id()) != null || this.restRequests.get(p.id()) != null) {
                    this.exec.submit(() -> {
                        try {
                            if (this.restRequestsV2.get(p.id()) != null) {
                                this.restRequestsV2.remove(p.id());
                                App.getRestServer().sendMsgBulkHistV2(p.id(), p.data(), true);
                            } else if (this.restRequests.get(p.id()) != null) {
                                this.restRequests.remove(p.id());
                                App.getRestServer().sendMsgBulkHist(p.clientMsg(), p.id(), p.data());
                            } else {
                                App.logger.error("Cannot find requests callback information for: " + p.id());
                            }
                        }
                        catch (Exception e) {
                            App.logger.error("ERROR", (Throwable)e);
                            try {
                                App.getRestServer().sendErrorV2(ErrorMsg.TERMINAL_PARSE, p.id(), "Please check your terminal log and send the error to support.");
                            }
                            catch (Exception x) {
                                App.logger.error("error with request: " + String.valueOf((Object)p.clientMsg()), (Throwable)x);
                            }
                        }
                    });
                    return;
                }
            }
            case CONTRACT_BULK: {
                if (this.restRequestsV2.get(p.id()) != null || this.restRequests.get(p.id()) != null) {
                    this.exec.submit(() -> {
                        try {
                            if (this.restRequestsV2.get(p.id()) != null) {
                                this.restRequestsV2.remove(p.id());
                                App.getRestServer().sendContractBulkV2(p.id(), p.data());
                            } else if (this.restRequests.get(p.id()) != null) {
                                this.restRequests.remove(p.id());
                                App.getRestServer().sendContractBulk(p.clientMsg(), p.id(), p.data());
                            } else {
                                App.logger.error("Cannot find requests callback information for: " + p.id());
                            }
                        }
                        catch (Exception e) {
                            App.logger.error("ERROR", (Throwable)e);
                            try {
                                App.getRestServer().sendErrorV2(ErrorMsg.TERMINAL_PARSE, p.id(), "Please check your terminal log and send the error to support.");
                            }
                            catch (Exception x) {
                                App.logger.error("error with request: " + String.valueOf((Object)p.clientMsg()), (Throwable)x);
                            }
                        }
                    });
                    return;
                }
            }
            case AT_TIME: 
            case LAST: 
            case HIST: {
                if (this.restRequestsV2.get(p.id()) != null || this.restRequests.get(p.id()) != null) {
                    this.exec.submit(() -> {
                        try {
                            if (this.restRequestsV2.get(p.id()) != null) {
                                this.restRequestsV2.remove(p.id());
                                App.getRestServer().sendMsgV2(p.id(), p.data(), p.clientMsg() != MessageType.LAST);
                            } else if (this.restRequests.get(p.id()) != null) {
                                this.restRequests.remove(p.id());
                                App.getRestServer().sendMsg(p.clientMsg(), p.id(), p.data());
                            } else {
                                App.logger.error("Cannot find requests callback information for: " + p.id());
                            }
                        }
                        catch (Exception e) {
                            App.logger.error("ERROR", (Throwable)e);
                            try {
                                App.getRestServer().sendErrorV2(ErrorMsg.TERMINAL_PARSE, p.id(), "Please check your terminal log and send the error to support.");
                            }
                            catch (Exception x) {
                                App.logger.error("error with request: " + String.valueOf((Object)p.clientMsg()), (Throwable)x);
                            }
                        }
                    });
                    return;
                }
                this.data.clear();
                byte size = -1;
                for (int i = 0; i < 256; ++i) {
                    try {
                        size = Interp3.addTicks(this.data, p.data());
                        break;
                    }
                    catch (BufferOverflowException e) {
                        this.data = ByteBuffer.allocate(Math.min(this.data.capacity() * 2, Integer.MAX_VALUE));
                        continue;
                    }
                    catch (Exception e) {
                        App.logger.info("An invalid message has been encountered. Please contact ThetaData support. Starting DEBUG...");
                        App.logger.info("Request: " + String.valueOf(CallbackCache.getReq(p.id())));
                        App.logger.info("Length: " + p.data().length);
                        App.logger.info("END DEBUG");
                        ClientServerV2.sendMsg(MessageType.ERROR, p.id(), (short)0, (short)0, (byte)0, ByteBuffer.wrap("Unexpected Error: Try making this request again.".getBytes()));
                    }
                }
                if (size < 0) {
                    throw new Exception("Negative tick size.");
                }
                try {
                    ClientServerV2.sendMsg(MessageType.HIST, p.id(), (short)0, (short)0, size, this.data.flip());
                }
                catch (NullPointerException e) {
                    App.logger.info("REQ_ID: " + p.id() + "REST IDS: " + String.valueOf(this.restRequests));
                    throw e;
                }
                return;
            }
            case ALL_DATES: 
            case ALL_DATES_BULK: 
            case ALL_ROOTS: 
            case ALL_EXPIRATIONS: 
            case ALL_STRIKES: {
                if (this.restRequestsV2.get(p.id()) != null || this.restRequests.get(p.id()) != null) {
                    this.exec.submit(() -> {
                        try {
                            if (this.restRequestsV2.get(p.id()) != null) {
                                this.restRequestsV2.remove(p.id());
                                App.getRestServer().sendMsgV2(p.clientMsg(), p.id(), new String(p.data()).split(","));
                            } else if (this.restRequests.get(p.id()) != null) {
                                this.restRequests.remove(p.id());
                                App.getRestServer().sendMsg(p.clientMsg(), p.id(), new String(p.data()).split(","));
                            } else {
                                App.logger.error("Cannot find requests callback information for: " + p.id());
                            }
                        }
                        catch (Exception e) {
                            App.logger.error("ERROR", (Throwable)e);
                            try {
                                App.getRestServer().sendErrorV2(ErrorMsg.TERMINAL_PARSE, p.id(), "Please check your terminal log and send the error to support.");
                            }
                            catch (Exception x) {
                                App.logger.debug("", (Throwable)x);
                            }
                        }
                    });
                    return;
                }
                ClientServerV2.sendMsg(p.clientMsg(), p.id(), (short)0, (short)0, (byte)0, ByteBuffer.wrap(p.data()));
                return;
            }
            case ERROR: {
                try {
                    String info = new String(p.data());
                    App.logger.debug("ERROR for request: " + p.id() + " info: " + info);
                    if (this.restRequestsV2.get(p.id()) != null) {
                        this.exec.submit(() -> {
                            try {
                                try {
                                    this.restRequestsV2.remove(p.id());
                                    App.getRestServer().sendErrorV2(ErrorMsg.valueOf(info.substring(0, info.indexOf(":"))), p.id(), info.substring(info.indexOf(":")));
                                }
                                catch (IllegalArgumentException e) {
                                    App.getRestServer().sendErrorV2(ErrorMsg.GENERAL, p.id(), info);
                                }
                            }
                            catch (Exception e) {
                                App.logger.error("ERROR", (Throwable)e);
                                try {
                                    App.getRestServer().sendErrorV2(ErrorMsg.TERMINAL_PARSE, p.id(), "Please check your terminal log and send the error to support.");
                                }
                                catch (Exception x) {
                                    App.logger.debug("", (Throwable)x);
                                }
                            }
                        });
                        return;
                    }
                    if (this.restRequests.get(p.id()) != null) {
                        this.exec.submit(() -> {
                            try {
                                try {
                                    this.restRequests.remove(p.id());
                                    App.getRestServer().sendError(ErrorMsg.valueOf(info.split(":")[0]), p.id(), info.split(":")[1]);
                                }
                                catch (IllegalArgumentException e) {
                                    App.getRestServer().sendError(ErrorMsg.GENERAL, p.id(), info);
                                }
                            }
                            catch (Exception e) {
                                App.logger.error("error with request: " + String.valueOf((Object)p.clientMsg()), (Throwable)e);
                            }
                        });
                    } else {
                        ClientServerV2.sendMsg(MessageType.ERROR, p.id(), (short)0, (short)1, (byte)0, ByteBuffer.wrap(p.data()));
                    }
                }
                catch (Exception e) {
                    App.logger.error("ERROR", (Throwable)e);
                }
                return;
            }
            case RECONNECTED: {
                App.logger.info(new String(p.data()));
                return;
            }
            case SESSION_TOKEN: {
                this.token = p.data();
                return;
            }
            case METADATA: {
                madeConnect.set(true);
                this.isConnected.set(true);
                this.perms = new String(p.data());
                App.logger.info("[MDDS] CONNECTED: [" + this.host + "], Bundle: " + this.perms);
                this.startPinging();
                return;
            }
            case DISCONNECTED: {
                this.last = RemoveReason.from(ByteBuffer.wrap(p.data()).getShort());
                App.logger.warn("[MDDS] Disconnected from server: " + String.valueOf((Object)this.last));
                if (!(madeConnect.get() || this.last != RemoveReason.INVALID_CREDENTIALS && this.last != RemoveReason.GENERAL_VALIDATION_ERROR)) {
                    App.logger.warn("Your password might contain invalid characters. Try resetting it at https://thetadata.net > sign out > log in > forgot password.");
                }
                this.host = null;
            }
        }
    }

    private void startPinging() {
        this.pinger = new Timer();
        this.pinger.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (MDDSClient.this.perms == null) {
                        MDDSClient.this.pinger.cancel();
                        return;
                    }
                    if (!MDDSClient.this.write(MessageType.PING, ByteBuffer.allocate(1))) {
                        MDDSClient.this.pinger.cancel();
                    }
                }
                catch (Exception e) {
                    MDDSClient.this.pinger.cancel();
                }
            }
        }, 2000L, 1000L);
    }

    private void handleInvoluntaryDisconnect() {
        App.getRestServer().handleConnectionLost();
        this.isConnected.set(false);
        if (this.last == RemoveReason.ACCOUNT_ALREADY_CONNECTED) {
            return;
        }
        final MDDSClient old = this;
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                App.handleInvoluntaryDisconnectMDDS(old);
            }
        }, this.last == RemoveReason.TOO_MANY_REQUESTS ? 20000L : 2000L);
    }

    private static void createTrust() throws IOException {
        File f = new File(App.ROOT_DIR, "client.jks");
        boolean exists = f.exists();
        f.createNewFile();
        Files.write(f.toPath(), App.class.getClassLoader().getResource("client.jks").openStream().readAllBytes(), new OpenOption[0]);
        if (!exists) {
            try {
                Thread.sleep(250L);
            }
            catch (Exception e) {
                App.logger.error("error sleeping for truststore: ", (Throwable)e);
            }
        }
        System.setProperty("javax.net.ssl.trustStore", f.toString());
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
    }

    public byte[] getToken() {
        return this.token;
    }

    public boolean isVerified() {
        return this.token != null && this.perms != null;
    }

    public boolean foundServer() {
        return this.foundServer.get();
    }

    public boolean isConnected() {
        return this.isConnected.get();
    }

    public String getPerms() {
        return this.perms;
    }
}

