/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.flatfiles;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.thetadata.enums.DataType;
import net.thetadata.enums.ReqArg;
import net.thetadata.enums.SecType;
import net.thetadata.terminal.Contract;
import net.thetadata.terminal.api.utils.PriceCalc;
import net.thetadata.terminal.cfg.Config;
import net.thetadata.terminal.dev.Entry;
import net.thetadata.terminal.dev.Location;
import net.thetadata.terminal.dev.OptionEntry;
import net.thetadata.terminal.dev.StockEntry;
import net.thetadata.terminal.io.Packet;
import net.thetadata.terminal.net.FITReader;
import net.thetadata.terminal.types.DataRequest;

public class FileBuilder {
    private static final ConcurrentHashMap<Long, FileMeta> metas = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, DataRequest> reqs = new ConcurrentHashMap();

    public static void putRequestInfo(long id, DataRequest req) {
        reqs.put(id, req);
    }

    public static void nuke(long id) throws IOException {
        FileMeta fm = metas.remove(id);
        reqs.remove(id);
        if (fm != null) {
            if (fm.index != null) {
                fm.index.delete();
            }
            if (fm.data != null) {
                fm.data.delete();
            }
            if (fm.bos != null) {
                fm.bos.close();
            }
        }
    }

    public static void handleIncomingData(Packet p) throws IOException {
        if (!metas.containsKey(p.id())) {
            FileMeta fm = new FileMeta();
            ByteBuffer buff = ByteBuffer.wrap(p.data());
            int fmtLen = buff.getInt();
            fm.fmt = new ArrayList<DataType>(fmtLen);
            for (int i = 0; i < fmtLen; ++i) {
                fm.fmt.add(DataType.from(buff.getInt()));
            }
            fm.indexLen = buff.getLong();
            fm.dataLen = buff.getLong();
            metas.put(p.id(), fm);
            return;
        }
        FileMeta fm = metas.get(p.id());
        if (!fm.finishedIndex) {
            if (fm.index == null) {
                fm.index = new File(new File(Config.workingDir(), "temp"), p.id() + ".index.tmp");
                fm.index.getParentFile().mkdirs();
                if (fm.index.exists()) {
                    fm.index.delete();
                }
                fm.bos = new BufferedOutputStream(new FileOutputStream(fm.index));
            }
            fm.bos.write(p.data());
            fm.indexCount += (long)p.data().length;
            if (fm.indexCount == fm.indexLen) {
                fm.bos.close();
                fm.finishedIndex = true;
            }
            return;
        }
        if (fm.data == null) {
            fm.data = new File(new File(Config.workingDir(), "temp"), p.id() + ".data.tmp");
            fm.data.getParentFile().mkdirs();
            if (fm.data.exists()) {
                fm.data.delete();
            }
            fm.bos = new BufferedOutputStream(new FileOutputStream(fm.data));
        }
        fm.bos.write(p.data());
        fm.dataCount += (long)p.data().length;
        if (fm.dataCount == fm.dataLen) {
            fm.bos.close();
            fm.finishedData = true;
        }
    }

    public static String handleFinish(Packet p) throws Exception {
        FileMeta fm = metas.get(p.id());
        DataRequest req = reqs.get(p.id());
        File dir = Config.getStr("FILE_DIR").equals("DEFAULT") ? new File(Config.workingDir(), "downloads") : new File(Config.getStr("FILE_DIR"));
        dir.mkdirs();
        File output = new File(dir, String.valueOf((Object)req.getSecType()) + "-" + String.valueOf((Object)req.getType()) + "-" + req.getInt(ReqArg.START_DATE) + ".csv");
        PrintWriter pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(output)));
        ByteBuffer in = ByteBuffer.wrap(Files.readAllBytes(fm.index.toPath()));
        RandomAccessFile rf = new RandomAccessFile(fm.data, "r");
        byte[] buff = new byte[1024];
        ByteBuffer entryBuff = ByteBuffer.allocate(1024);
        Entry dummy = req.getSecType() == SecType.OPTION ? new OptionEntry() : new StockEntry();
        ArrayList<DataType> headerFormat = new ArrayList<DataType>(fm.fmt);
        boolean hasPriceType = fm.fmt.contains((Object)DataType.PRICE_TYPE);
        if (hasPriceType) {
            headerFormat.remove(fm.fmt.size() - 2);
        }
        String fmtStr = ((Object)headerFormat).toString().replace("[", "").replace("]", "").replace(" ", "").toLowerCase();
        if (req.getSecType() == SecType.OPTION) {
            pw.println("root,expiration,strike,right," + fmtStr);
        } else {
            pw.println("root," + fmtStr);
        }
        while (in.hasRemaining()) {
            short h2 = in.getShort();
            in.get(buff, 0, h2);
            Entry entry = dummy.newEntry();
            entryBuff.clear();
            entry.fromBytes(entryBuff.put(buff, 0, h2).flip());
            Location l = Location.to(in);
            Contract con = req.getSecType() == SecType.OPTION ? new Contract(false).read((OptionEntry)entry) : new Contract(false).read((StockEntry)entry);
            byte[] temp = new byte[(int)l.size()];
            rf.getChannel().position(l.start());
            rf.read(temp);
            FITReader fr = new FITReader();
            fr.open(temp);
            FileBuilder.toCSV2(fm.fmt, fr, hasPriceType ? fm.fmt.size() - 2 : -1, pw, con);
        }
        rf.close();
        pw.close();
        return output.toString();
    }

    private static void toCSV2(List<DataType> format, FITReader fr, int pTypeIndex, PrintWriter pw, Contract con) throws Exception {
        StringBuilder sb = new StringBuilder();
        while (fr.readTick() != null) {
            int[] tick = fr.peek().data();
            sb.setLength(0);
            if (con.sec == SecType.OPTION) {
                sb.append(con.root).append(',').append(con.exp).append(',').append(con.strike).append(',').append(con.isCall ? "C" : "P").append(',');
            } else {
                sb.append(con.root).append(',');
            }
            for (int i = 0; i < tick.length; ++i) {
                if (i == pTypeIndex) continue;
                if (format.get(i).isPrice()) {
                    PriceCalc.fmtPrice(sb, PriceCalc.getPriceDouble(tick[i], tick[pTypeIndex]), 4);
                } else {
                    sb.append(tick[i]);
                }
                sb.append(',');
            }
            sb.setLength(sb.length() - 1);
            pw.println(sb);
        }
    }

    private static class FileMeta {
        private long indexLen;
        private long dataLen;
        private long indexCount;
        private long dataCount;
        private List<DataType> fmt;
        private File index;
        private File data;
        private BufferedOutputStream bos;
        private boolean finishedIndex;
        private boolean finishedData;

        private FileMeta() {
        }
    }
}

