/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.cmds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CommandExecutor {
    private static final Logger logger = LogManager.getLogger(CommandExecutor.class);
    public static final ConcurrentHashMap<String, CommandExecutor> cmds = new ConcurrentHashMap();

    protected abstract void process(String var1, String[] var2) throws IOException;

    protected abstract String description();

    public static void startReading() {
        new Thread(() -> {
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            while (true) {
                try {
                    while (true) {
                        String argString;
                        if ((argString = r.readLine()) == null) {
                            continue;
                        }
                        String[] args = argString.toLowerCase().split(" ");
                        if (cmds.containsKey(args[0])) {
                            cmds.get(args[0]).process(args[0], Arrays.copyOfRange(args, 1, args.length));
                            continue;
                        }
                        logger.warn("Unknown Command. Type help for a list of commands.");
                    }
                }
                catch (Exception e) {
                    logger.error("Error parsing command: ", (Throwable)e);
                    continue;
                }
                break;
            }
        }).start();
    }

    public static void register(String cmd, CommandExecutor exec) {
        cmds.put(cmd.toLowerCase(), exec);
    }

    public static void helpList() {
        for (String s2 : cmds.keySet()) {
            System.out.println(s2 + ": " + cmds.get(s2).description());
        }
    }
}

