/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.types;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.thetadata.enums.ReqArg;
import net.thetadata.enums.ReqType;
import net.thetadata.enums.SecType;
import net.thetadata.terminal.App;
import net.thetadata.terminal.Contract;
import net.thetadata.terminal.api.types.MessageType;
import net.thetadata.terminal.types.CallbackCache;

public class DataRequest {
    private SecType secType;
    private final HashMap<ReqArg, String> args;
    private Contract con;
    private ReqType type;
    private final HashMap<ReqArg, String> req = new HashMap(8);
    private static final String SEPARATOR = "=";
    private final String error;

    public DataRequest(String argStr, boolean allowID) {
        String[] argPairs;
        ReqArg[] requiredArgs;
        argStr = ((String)argStr).toUpperCase();
        for (ReqArg arg : requiredArgs = new ReqArg[]{ReqArg.MSG_CODE}) {
            if (!allowID && ((String)argStr).toLowerCase().contains("id=")) {
                throw new IllegalArgumentException("argStr must not contain the ID argument!");
            }
            if (((String)argStr).contains(arg.name())) continue;
            throw new IllegalArgumentException("argStr is missing the " + arg.name() + " argument!");
        }
        if (!allowID) {
            long id = CallbackCache.REQ_ID.incrementAndGet();
            argStr = (String)argStr + "&ID=" + id;
        }
        this.args = new HashMap(8);
        for (String argPair : argPairs = ((String)argStr).split("&")) {
            String[] kv = argPair.split(SEPARATOR);
            ReqArg k = ReqArg.from(kv[0]);
            if (k == null) {
                throw new IllegalStateException("argStr contains invalid argument: " + kv[0]);
            }
            String prev = this.args.put(k, kv[1]);
            if (prev == null) continue;
            throw new IllegalStateException("argStr contains duplicate argument: " + k.name());
        }
        this.error = this.syntaxValidation(argPairs);
    }

    public DataRequest(String argStr) {
        this(argStr, false);
    }

    public DataRequest(MessageType type, Long id, String argStr) {
        this(String.valueOf((Object)ReqArg.MSG_CODE) + SEPARATOR + type.code() + "&" + argStr);
    }

    private String syntaxValidation(String[] args) {
        try {
            for (String s2 : args) {
                String[] kv = s2.split(SEPARATOR);
                if (kv.length != 2) {
                    return s2 + " is not a valid argument.";
                }
                ReqArg rq = ReqArg.from(kv[0].toUpperCase());
                if (rq == null) {
                    return s2 + " is not a valid argument.";
                }
                if (rq.getType() == 0) {
                    this.req.put(rq, kv[1]);
                    continue;
                }
                if (rq.getType() == 1) {
                    Integer.parseInt(kv[1]);
                } else if (rq.getType() == 2) {
                    Double.parseDouble(kv[1]);
                } else if (rq.getType() == 3) {
                    Boolean.parseBoolean(kv[1]);
                }
                this.req.put(rq, kv[1]);
            }
        }
        catch (NumberFormatException e) {
            App.logger.debug("PARSING ERROR: " + Arrays.toString(args), (Throwable)e);
            return e.getMessage();
        }
        catch (Exception e) {
            App.logger.debug("error building request", (Throwable)e);
            return e.getMessage();
        }
        String t2 = this.req.get((Object)ReqArg.REQ);
        if (t2 == null) {
            return "request type field cannot be null";
        }
        this.type = ReqType.from(Integer.parseInt(t2));
        if (this.type == null) {
            App.logger.debug("Invalid request type: " + Arrays.toString(args));
            return "Invalid request type";
        }
        t2 = this.req.get((Object)ReqArg.SEC);
        if (t2 != null) {
            this.secType = SecType.valueOf(t2.toUpperCase());
        }
        if (this.secType == null) {
            return "Invalid secType";
        }
        t2 = this.req.get((Object)ReqArg.USE_EXACT_TIME);
        return null;
    }

    public boolean isRTH() {
        return !this.args.containsKey((Object)ReqArg.RTH) || this.getBoolean(ReqArg.RTH);
    }

    public boolean getBoolean(ReqArg r) {
        return Boolean.parseBoolean(this.args.get((Object)r));
    }

    public int getInt(ReqArg r) {
        return Integer.parseInt(this.args.get((Object)r));
    }

    public boolean hasArg(ReqArg r) {
        return this.args.containsKey((Object)r);
    }

    public String getStr(ReqArg r) {
        return this.args.get((Object)r);
    }

    public long getId() {
        return this.getInt(ReqArg.ID);
    }

    public MessageType getMsgType() {
        return MessageType.from((short)this.getInt(ReqArg.MSG_CODE));
    }

    public SecType getSecType() {
        return SecType.from(this.getStr(ReqArg.SEC));
    }

    public String toString() {
        StringBuilder b = new StringBuilder(50);
        for (Map.Entry<ReqArg, String> entry : this.args.entrySet()) {
            b.append((Object)entry.getKey()).append('=').append(entry.getValue()).append('&');
        }
        b.deleteCharAt(b.length() - 1);
        return b.toString();
    }

    public ReqType getType() {
        return this.type;
    }

    public Contract getContract() {
        return this.con;
    }

    public String buildContract() {
        if (this.getStr(ReqArg.ROOT) == null && this.secType != SecType.RATE) {
            return "Request must contain the root field";
        }
        if (this.secType == null) {
            if (!this.hasArg(ReqArg.SEC)) {
                return "No security type field provided.";
            }
            this.secType = SecType.from(this.getStr(ReqArg.SEC));
            if (this.secType == null) {
                return "Invalid security type: " + this.getStr(ReqArg.SEC);
            }
        }
        if (this.secType == SecType.OPTION) {
            if (this.getStr(ReqArg.EXP) == null) {
                return "No expiration provided.";
            }
            if (this.getStr(ReqArg.STRIKE) == null) {
                return "No strike provided.";
            }
            if (this.getStr(ReqArg.RIGHT) == null) {
                return "No right provided.";
            }
            this.con = new Contract(false).read(this.getStr(ReqArg.ROOT), this.getInt(ReqArg.EXP), this.getInt(ReqArg.STRIKE), this.getStr(ReqArg.RIGHT).charAt(0) == 'C');
        } else {
            this.con = new Contract(false).read(this.getStr(ReqArg.ROOT));
            this.con.sec = this.secType;
        }
        return null;
    }

    public String toNiceString() {
        if (this.buildContract() != null) {
            return null;
        }
        return String.valueOf((Object)this.type) + "." + this.con.toNiceString() + "." + this.getStr(ReqArg.START_DATE) + "-" + this.getStr(ReqArg.END_DATE) + "." + String.valueOf(this.getStr(ReqArg.IVL) == null ? Integer.valueOf(0) : this.getStr(ReqArg.IVL));
    }
}

