/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.enums;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum AccountType {
    FREE("FREE"),
    VALUE("VALUE"),
    STANDARD("STANDARD"),
    PRO("PRO");

    private static final Logger logger;
    private final String type;

    private AccountType(String s2) {
        this.type = s2;
    }

    public static AccountType from(String accountType) throws IllegalArgumentException {
        if (accountType == null || accountType.isBlank() || "undefined".equals(accountType)) {
            logger.debug("Invalid value for accountType, setting to FREE: {}", (Object)accountType);
            return FREE;
        }
        for (AccountType t2 : AccountType.values()) {
            if (!t2.type.equalsIgnoreCase(accountType)) continue;
            return t2;
        }
        throw new IllegalArgumentException("Unknown account type: " + accountType);
    }

    public static AccountType from(int accountType) throws IllegalArgumentException {
        switch (accountType) {
            case 0: {
                return FREE;
            }
            case 1: {
                return VALUE;
            }
            case 2: {
                return STANDARD;
            }
            case 3: {
                return PRO;
            }
        }
        throw new IllegalArgumentException("Unknown account type: " + accountType);
    }

    public String toString() {
        return this.type;
    }

    public String toFullString() {
        if (this == PRO) {
            return "PROFESSIONAL";
        }
        return this.type;
    }

    static {
        logger = LogManager.getLogger(AccountType.class);
    }
}

