/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.enums;

public enum DataType {
    DATE(0),
    MS_OF_DAY(1),
    CORRECTION(2),
    PRICE_TYPE(4),
    MS_OF_DAY2(5),
    UNDEFINED(6),
    BID_SIZE(101),
    BID_EXCHANGE(102),
    BID(103, true),
    BID_CONDITION(104),
    ASK_SIZE(105),
    ASK_EXCHANGE(106),
    ASK(107, true),
    ASK_CONDITION(108),
    MIDPOINT(111, true),
    VWAP(112, true),
    QWAP(113, true),
    WAP(114, true),
    OPEN_INTEREST(121),
    SEQUENCE(131),
    SIZE(132),
    CONDITION(133),
    PRICE(134, true),
    EXCHANGE(135),
    CONDITION_FLAGS(136),
    PRICE_FLAGS(137),
    VOLUME_TYPE(138),
    RECORDS_BACK(139),
    VOLUME(141),
    COUNT(142),
    THETA(151, true),
    VEGA(152, true),
    DELTA(153, true),
    RHO(154, true),
    EPSILON(155, true),
    LAMBDA(156, true),
    GAMMA(161, true),
    VANNA(162, true),
    CHARM(163, true),
    VOMMA(164, true),
    VETA(165, true),
    VERA(166, true),
    SOPDK(167, true),
    SPEED(171, true),
    ZOMMA(172, true),
    COLOR(173, true),
    ULTIMA(174, true),
    D1(181, true),
    D2(182, true),
    DUAL_DELTA(183, true),
    DUAL_GAMMA(184, true),
    OPEN(191, true),
    HIGH(192, true),
    LOW(193, true),
    CLOSE(194, true),
    NET_CHANGE(195, true),
    IMPLIED_VOL(201, true),
    BID_IMPLIED_VOL(202, true),
    ASK_IMPLIED_VOL(203, true),
    UNDERLYING_PRICE(204, true),
    IV_ERROR(205, true),
    RATIO(211, true),
    RATING(212, true),
    EX_DATE(221),
    RECORD_DATE(222),
    PAYMENT_DATE(223),
    ANN_DATE(224),
    DIVIDEND_AMOUNT(225, true),
    LESS_AMOUNT(226, true),
    RATE(230, true),
    EXT_CONDITION1(241),
    EXT_CONDITION2(242),
    EXT_CONDITION3(243),
    EXT_CONDITION4(244),
    SPLIT_DATE(251),
    BEFORE_SHARES(252),
    AFTER_SHARES(253),
    OUTSTANDING_SHARES(261),
    SHORT_SHARES(262),
    INSTITUTIONAL_INTEREST(263, true),
    LAST_FISCAL_QUARTER(264),
    LAST_FISCAL_YEAR(265),
    ASSETS(266, true),
    LIABILITIES(267, true),
    LONG_TERM_DEBT(268, true),
    EPS_MRQ(269, true),
    EPS_MRY(270, true),
    EPS_DILUTED(271, true),
    SYMBOL_CHANGE_DATE(272),
    SYMBOL_CHANGE_TYPE(273),
    SYMBOL(274, false, true);

    private final int code;
    private final String name;
    private final boolean isPrice;
    private final boolean isStr;
    private final boolean isDate;

    private DataType(int i) {
        this(i, false);
    }

    private DataType(int i, boolean isPrice) {
        this(i, isPrice, false);
    }

    private DataType(int i, boolean isPrice, boolean isStr) {
        this.code = i;
        this.name = this.name().toLowerCase();
        this.isPrice = isPrice;
        this.isStr = isStr;
        this.isDate = this.name.toUpperCase().contains("DATE");
    }

    public static DataType from(int code) {
        for (DataType d : DataType.values()) {
            if (d.code != code) continue;
            return d;
        }
        return UNDEFINED;
    }

    public int code() {
        return this.code;
    }

    public boolean isPrice() {
        return this.isPrice;
    }

    public boolean isStr() {
        return this.isStr;
    }

    public boolean isDate() {
        return this.isDate;
    }

    public String toString() {
        return this.name;
    }
}

