/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.dev;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.thetadata.enums.DataType;
import net.thetadata.terminal.Contract;
import net.thetadata.terminal.api.utils.PriceCalc;
import net.thetadata.terminal.dev.Location;
import net.thetadata.terminal.dev.OptionEntry;
import net.thetadata.terminal.net.FITReader;

public class FlatFiles {
    public static void main(String[] args) throws IOException, InterruptedException {
        DataType[] format3 = new DataType[]{DataType.MS_OF_DAY, DataType.SEQUENCE, DataType.EXT_CONDITION1, DataType.EXT_CONDITION2, DataType.EXT_CONDITION3, DataType.EXT_CONDITION4, DataType.CONDITION, DataType.SIZE, DataType.EXCHANGE, DataType.PRICE, DataType.CONDITION_FLAGS, DataType.PRICE_FLAGS, DataType.VOLUME_TYPE, DataType.RECORDS_BACK, DataType.MS_OF_DAY2, DataType.BID_SIZE, DataType.BID_EXCHANGE, DataType.BID, DataType.BID_CONDITION, DataType.ASK_SIZE, DataType.ASK_EXCHANGE, DataType.ASK, DataType.ASK_CONDITION, DataType.PRICE_TYPE, DataType.DATE};
        DataType[] headerFormat3 = new DataType[]{DataType.MS_OF_DAY, DataType.SEQUENCE, DataType.EXT_CONDITION1, DataType.EXT_CONDITION2, DataType.EXT_CONDITION3, DataType.EXT_CONDITION4, DataType.CONDITION, DataType.SIZE, DataType.EXCHANGE, DataType.PRICE, DataType.CONDITION_FLAGS, DataType.PRICE_FLAGS, DataType.VOLUME_TYPE, DataType.RECORDS_BACK, DataType.MS_OF_DAY2, DataType.BID_SIZE, DataType.BID_EXCHANGE, DataType.BID, DataType.BID_CONDITION, DataType.ASK_SIZE, DataType.ASK_EXCHANGE, DataType.ASK, DataType.ASK_CONDITION, DataType.DATE};
        int start = 0;
        int end = 20251131;
        File dataDir = new File(args[0]);
        File indexDir = new File(args[1]);
        File tempDir = new File(args[2]);
        File outDir = new File(args[3]);
        HashSet<Integer> recordedDates = new HashSet<Integer>();
        for (File f : outDir.listFiles()) {
            if (!f.getName().contains(".zip")) continue;
            recordedDates.add(Integer.parseInt(f.getName().substring(0, f.getName().indexOf(".zip"))));
        }
        System.out.println(String.valueOf(LocalDateTime.now()) + " Recorded dates: " + recordedDates.size());
        System.out.println(String.valueOf(LocalDateTime.now()) + ": Started.");
        int threadCount = 6;
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < 6) {
            int id = i++;
            threads.add(new Thread(() -> {
                try {
                    for (File data : dataDir.listFiles()) {
                        int date = Integer.parseInt(data.getName());
                        if (recordedDates.contains(date) || date < start || end < date || date % 6 != id) continue;
                        System.out.println(String.valueOf(LocalDateTime.now()) + ": Started date: " + date);
                        File index = new File(indexDir, date + ".tdi");
                        File outDateDir = new File(tempDir, "" + date);
                        outDateDir.mkdirs();
                        RandomAccessFile rf = new RandomAccessFile(data, "r");
                        ByteBuffer in = ByteBuffer.wrap(Files.readAllBytes(index.toPath()));
                        HashMap<String, PrintWriter> files = new HashMap<String, PrintWriter>();
                        byte[] buff = new byte[1024];
                        ByteBuffer entryBuff = ByteBuffer.allocate(1024);
                        OptionEntry dummy = new OptionEntry();
                        while (in.hasRemaining()) {
                            Object temp;
                            short h2 = in.getShort();
                            in.get(buff, 0, h2);
                            OptionEntry entry = dummy.newEntry();
                            entryBuff.clear();
                            entry.fromBytes(entryBuff.put(buff, 0, h2).flip());
                            Location l = Location.to(in);
                            Contract con = new Contract(false).read(entry);
                            if (!files.containsKey(con.root)) {
                                temp = new File(outDateDir, "_" + con.root + ".csv");
                                ((File)temp).createNewFile();
                                files.put(con.root, new PrintWriter(new BufferedWriter(new FileWriter((File)temp))));
                                ((PrintWriter)files.get(con.root)).println("root,expiration,strike,right," + Arrays.toString((Object[])headerFormat3).replace("[", "").replace("]", "").replace(" ", "").toLowerCase());
                            }
                            temp = new byte[(int)l.size()];
                            rf.getChannel().position(l.start());
                            rf.read((byte[])temp);
                            FITReader fr = new FITReader();
                            fr.open((byte[])temp);
                            FlatFiles.toCSV2(format3, fr, 23, (PrintWriter)files.get(con.root), con);
                        }
                        for (PrintWriter pw : files.values()) {
                            pw.close();
                        }
                        File zippedData = new File(outDateDir.getParent(), outDateDir.getName() + ".zip");
                        FlatFiles.pack(outDateDir.getPath(), zippedData.getPath());
                        for (File f : outDateDir.listFiles()) {
                            f.delete();
                        }
                        outDateDir.delete();
                        Files.copy(zippedData.toPath(), new File(outDir, zippedData.getName()).toPath(), new CopyOption[0]);
                        zippedData.delete();
                        System.out.println(String.valueOf(LocalDateTime.now()) + ": Finished date: " + date);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }));
            ((Thread)threads.get(threads.size() - 1)).start();
        }
        for (Thread t2 : threads) {
            t2.join();
        }
        System.out.println(String.valueOf(LocalDateTime.now()) + ": Finished everything");
    }

    public static void pack(String sourceDirPath, String zipFilePath) throws IOException {
        Path p = Files.createFile(Paths.get(zipFilePath, new String[0]), new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            zs.setLevel(1);
            Path pp = Paths.get(sourceDirPath, new String[0]);
            Files.walk(pp, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public static void toCSV2(DataType[] format, FITReader fr, int pTypeIndex, PrintWriter pw, Contract con) {
        StringBuilder sb = new StringBuilder();
        while (fr.readTick() != null) {
            int[] tick = fr.peek().data();
            sb.setLength(0);
            sb.append(con.root).append(',').append(con.exp).append(',').append(con.strike).append(',').append(con.isCall ? "C" : "P").append(',');
            for (int i = 0; i < tick.length; ++i) {
                if (i == pTypeIndex) continue;
                if (format[i].isPrice()) {
                    PriceCalc.fmtPrice(sb, PriceCalc.getPriceDouble(tick[i], tick[pTypeIndex]), 4);
                } else {
                    sb.append(tick[i]);
                }
                sb.append(',');
            }
            sb.setLength(sb.length() - 1);
            pw.println(sb);
        }
    }
}

