/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.dev;

import java.nio.ByteBuffer;
import net.thetadata.terminal.dev.Entry;

public class OptionEntry
extends Entry {
    private String root;
    private int exp;
    private int date;
    private int strike;
    private char right;
    private transient int rootHash;
    private transient int hash;

    public String getRoot() {
        return this.root;
    }

    public int getStrike() {
        return this.strike;
    }

    public int getExp() {
        return this.exp;
    }

    public char getRight() {
        return this.right;
    }

    @Override
    public int getDate() {
        return this.date;
    }

    @Override
    public void fromBytes(ByteBuffer buff) {
        byte[] rt = new byte[buff.get()];
        buff.get(rt);
        this.root = new String(rt);
        this.exp = buff.getInt();
        this.right = (char)buff.get();
        this.strike = buff.getInt();
        this.date = buff.getInt();
        this.computeHashes();
    }

    private void computeHashes() {
        this.rootHash = this.root.hashCode();
        this.hash = this.rootHash + (this.strike >> 4);
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OptionEntry)) {
            return false;
        }
        OptionEntry e = (OptionEntry)o;
        return this.exp == e.exp && this.right == e.right && this.root.equals(e.root) && this.strike == e.strike && this.date == e.date;
    }

    public String toString() {
        return "root: " + this.root + " exp: " + this.exp + " right: " + this.right + " strike: " + this.strike + " date: " + this.date;
    }

    @Override
    public OptionEntry newEntry() {
        return new OptionEntry();
    }

    public void setRoot(String s2) {
        this.root = s2;
        this.rootHash = s2.hashCode();
    }
}

