/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.http;

import net.thetadata.terminal.cfg.Config;
import net.thetadata.terminal.http.EventServlet;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class WSServer {
    private final Server server;

    public WSServer() {
        Log.setLog(new NoLogging());
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(Config.getInt("WS_PORT"));
        this.server.addConnector(connector);
        ServletContextHandler handler = new ServletContextHandler(1);
        handler.setContextPath("/");
        this.server.setHandler(handler);
        handler.addServlet(EventServlet.class, "/v1/events");
        new Thread(() -> {
            try {
                this.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).start();
    }

    private void start() throws Exception {
        this.server.start();
        this.server.join();
    }

    public void shutdown() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class NoLogging
    implements Logger {
        private NoLogging() {
        }

        @Override
        public String getName() {
            return "no";
        }

        @Override
        public void warn(String msg, Object ... args) {
        }

        @Override
        public void warn(Throwable thrown) {
        }

        @Override
        public void warn(String msg, Throwable thrown) {
        }

        @Override
        public void info(String msg, Object ... args) {
        }

        @Override
        public void info(Throwable thrown) {
        }

        @Override
        public void info(String msg, Throwable thrown) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public void setDebugEnabled(boolean enabled) {
        }

        @Override
        public void debug(String msg, Object ... args) {
        }

        @Override
        public void debug(String s2, long l) {
        }

        @Override
        public void debug(Throwable thrown) {
        }

        @Override
        public void debug(String msg, Throwable thrown) {
        }

        @Override
        public Logger getLogger(String name) {
            return this;
        }

        @Override
        public void ignore(Throwable ignored) {
        }
    }
}

