/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.thetadata.terminal.api.types.MessageType;
import net.thetadata.terminal.io.Packet;

public class PacketStream {
    private final InputStream in;
    private final OutputStream out;
    private final int lim;
    private final Object writeLock = new Object();
    private final Object readLock = new Object();
    private final ByteBuffer codeBuffer = ByteBuffer.allocate(2);
    private final ByteBuffer idBuffer = ByteBuffer.allocate(8);
    private final ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
    private final ByteBuffer codeBufferIn = ByteBuffer.allocate(2);
    private final ByteBuffer idBufferIn = ByteBuffer.allocate(8);
    private final ByteBuffer sizeBufferIn = ByteBuffer.allocate(4);

    public PacketStream(InputStream in, OutputStream out) {
        this(in, out, Integer.MAX_VALUE);
    }

    public PacketStream(InputStream in, OutputStream out, int lim) {
        this.in = in;
        this.out = out;
        this.lim = lim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet read() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            byte[] buff = this.in.readNBytes(this.sizeBufferIn.capacity());
            if (buff.length != this.sizeBufferIn.capacity()) {
                throw new IOException("End of stream.");
            }
            this.sizeBufferIn.clear().put(buff).flip();
            buff = this.in.readNBytes(this.codeBufferIn.capacity());
            if (buff.length != this.codeBufferIn.capacity()) {
                throw new IOException("End of stream.");
            }
            this.codeBufferIn.clear().put(buff).flip();
            buff = this.in.readNBytes(this.idBufferIn.capacity());
            if (buff.length != this.idBufferIn.capacity()) {
                throw new IOException("End of stream.");
            }
            this.idBufferIn.clear().put(buff).flip();
            int size = this.sizeBufferIn.getInt();
            if (size > this.lim || size <= 0) {
                throw new IOException("Invalid packet size: " + size + " for limit: " + this.lim);
            }
            byte[] data = this.in.readNBytes(size);
            if (data.length == 0 || data.length != size) {
                throw new IOException("End of stream.");
            }
            return new Packet(this.codeBufferIn.getShort(), this.idBufferIn.getLong(), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MessageType type, long id, ByteBuffer data) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.out.write(this.sizeBuffer.clear().putInt(data.limit()).array());
            this.out.write(this.codeBuffer.clear().putShort(type.code()).array());
            this.out.write(this.idBuffer.clear().putLong(id).array());
            this.out.write(data.array(), 0, data.limit());
            this.out.flush();
        }
    }
}

