/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.terminal.net;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.thetadata.enums.StreamMsgType;
import net.thetadata.terminal.net.StreamPacket;

public class PacketStream2 {
    private final DataInputStream in;
    private final DataOutputStream out;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();

    public PacketStream2(InputStream in, OutputStream out) {
        this.in = new DataInputStream(new BufferedInputStream(in, 4096));
        this.out = new DataOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCopy(StreamPacket ref) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            ref.len = this.in.readByte() & 0xFF;
            ref.code = this.in.readByte() & 0xFF;
            int bytesRead = this.in.readNBytes(ref.data, 0, ref.len);
            if (bytesRead == 0 || bytesRead != ref.len) {
                throw new IOException("End of stream.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(StreamMsgType type, byte[] data, int len) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (len < 0 || len > 255) {
                throw new IOException("Length must be greater than 0. Current value: " + len);
            }
            this.out.writeByte(len);
            this.out.writeByte(type.code());
            this.out.write(data, 0, len);
            if (type == StreamMsgType.PING) {
                this.out.flush();
            }
        }
    }
}

